/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.statement;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.NoAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.runtime.api.util.Preconditions;

public class QueryStatementFactory
implements ConfigurableStatementFactory {
    private int maxRows;
    private Integer fetchSize;
    private int queryTimeout = 0;

    @Override
    public Statement create(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        return this.create(connection, queryTemplate, new NoAutoGenerateKeysStrategy());
    }

    @Override
    public Statement create(DbConnection connection, QueryTemplate queryTemplate, AutoGenerateKeysStrategy autoGenerateKeysStrategy) throws SQLException {
        Statement result;
        if (queryTemplate.getType().equals((Object)QueryType.STORE_PROCEDURE_CALL)) {
            DatabaseMetaData metadata = connection.getJdbcConnection().getMetaData();
            int resultSetType = metadata.supportsResultSetType(1004) ? 1004 : (metadata.supportsResultSetType(1005) ? 1005 : 1003);
            result = connection.getJdbcConnection().prepareCall(queryTemplate.getSqlText(), resultSetType, 1007);
        } else {
            boolean hasInputParams = queryTemplate.getInputParams().size() > 0;
            result = hasInputParams ? autoGenerateKeysStrategy.prepareStatement(connection, queryTemplate) : connection.getJdbcConnection().createStatement();
        }
        if (this.maxRows > 0) {
            result.setMaxRows(this.maxRows);
        }
        if (this.fetchSize != null) {
            result.setFetchSize(this.fetchSize);
        }
        if (this.queryTimeout != 0) {
            result.setQueryTimeout(this.queryTimeout);
        }
        return result;
    }

    @Override
    public void setMaxRows(int max) {
        this.maxRows = max;
    }

    @Override
    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        Preconditions.checkArgument((queryTimeout >= 0 ? 1 : 0) != 0, (String)"Query timeout must be positive");
        this.queryTimeout = queryTimeout;
    }
}

