/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.type.resolver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.connection.type.resolver.StructAndArrayTypeResolver;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

public class ArrayTypeResolver
implements StructAndArrayTypeResolver {
    public static final String QUERY_ALL_COLL_TYPES = "SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ?";
    private static final String QUERY_OWNER_CONDITION = " AND OWNER = ?";
    private static final String ELEM_TYPE_NAME = "ELEM_TYPE_NAME";
    private DefaultDbConnection connection;

    public ArrayTypeResolver(DefaultDbConnection connection) {
        this.connection = connection;
    }

    @Override
    public void resolveLobs(Object[] elements, Integer index, String dataTypeName) throws SQLException {
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            if (element instanceof Struct) continue;
            if (element instanceof Collection) {
                Object[] objects = ((List)element).toArray();
                this.connection.doResolveLobIn(objects, index, dataTypeName);
                elements[i] = objects;
                continue;
            }
            if (element instanceof Iterable) {
                Spliterator spliterator = ((Iterable)element).spliterator();
                Object[] objects = StreamSupport.stream(spliterator, false).toArray();
                this.connection.doResolveLobIn(objects, index, dataTypeName);
                elements[i] = objects;
                continue;
            }
            if (element instanceof Object[]) {
                this.connection.doResolveLobIn((Object[])element, index, dataTypeName);
                continue;
            }
            throw new RuntimeException(String.format("Unable to process arguments of type %s", element.getClass()));
        }
    }

    @Override
    public String resolveType(String typeName) throws SQLException {
        String collectionTypeName = this.getTypeFor(typeName);
        if (collectionTypeName != null) {
            return collectionTypeName;
        }
        return typeName;
    }

    @Override
    public String resolveType(String typeName, ConcurrentHashMap<String, String> typeCache) throws SQLException {
        if (typeCache.containsKey(typeName)) {
            return typeCache.get(typeName);
        }
        String resolvedType = this.resolveType(typeName);
        typeCache.put(typeName, resolvedType);
        return resolvedType;
    }

    @Override
    public void resolveLobIn(Object[] attributes, Integer index, ResolvedDbType resolvedDbType) throws SQLException {
        for (Object attribute : attributes) {
            this.connection.doResolveLobIn((Object[])attribute, index, resolvedDbType.getId(), resolvedDbType.getName());
        }
    }

    private String getTypeFor(String collectionTypeName) throws SQLException {
        String dataType = null;
        Optional<String> owner = ArrayTypeResolver.getOwnerFrom(collectionTypeName);
        String typeName = ArrayTypeResolver.getTypeSimpleName(collectionTypeName);
        String query = QUERY_ALL_COLL_TYPES + (owner.isPresent() ? QUERY_OWNER_CONDITION : "");
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setString(1, typeName);
            if (owner.isPresent()) {
                ps.setString(2, owner.get());
            }
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    dataType = resultSet.getString(ELEM_TYPE_NAME);
                }
            }
        }
        return dataType;
    }

    public static Optional<String> getOwnerFrom(String typeName) {
        return typeName.contains(".") ? Optional.of(typeName.substring(0, typeName.indexOf(46))) : Optional.empty();
    }

    public static String getTypeSimpleName(String typeName) {
        if (!typeName.contains(".")) {
            return typeName;
        }
        return typeName.substring(typeName.indexOf(46) + 1);
    }
}

