/*
 * Decompiled with CFR 0.152.
 */
package org.mule.oauth.client.internal.http;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.oauth.client.api.http.HttpClientFactory;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class DefaultHttpClientFactory
implements HttpClientFactory {
    private static final String HTTP_CLIENT_NAME = "oauthToken.requester";
    private LoadingCache<Pair<TlsContextFactory, ProxyConfig>, HttpClient> cache = Caffeine.newBuilder().build(key -> {
        HttpClientConfiguration.Builder clientConfigBuilder = new HttpClientConfiguration.Builder().setName(HTTP_CLIENT_NAME);
        clientConfigBuilder.setTlsContextFactory((TlsContextFactory)key.getFirst());
        clientConfigBuilder.setProxyConfig((ProxyConfig)key.getSecond());
        final HttpClient innerClient = httpService.getClientFactory().create(clientConfigBuilder.build());
        return new HttpClient(){
            private final AtomicInteger startedCounter = new AtomicInteger(0);
            private final Latch startLatch = new Latch();
            final /* synthetic */ Pair val$key;
            {
                this.val$key = pair;
            }

            public void start() {
                if (0 == this.startedCounter.getAndIncrement()) {
                    innerClient.start();
                    this.startLatch.release();
                }
                try {
                    this.startLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            public void stop() {
                if (0 == this.startedCounter.decrementAndGet()) {
                    innerClient.stop();
                    DefaultHttpClientFactory.this.cache.invalidate((Object)this.val$key);
                }
            }

            public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
                return innerClient.send(request, options);
            }

            public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
                return innerClient.sendAsync(request, options);
            }
        };
    });

    public DefaultHttpClientFactory(HttpService httpService) {
    }

    @Override
    public HttpClient create(TlsContextFactory tlsContextFactory, ProxyConfig proxyConfig) {
        return (HttpClient)this.cache.get((Object)new Pair((Object)tlsContextFactory, (Object)proxyConfig));
    }
}

