/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.oauth.client.internal.util;

import java.io.IOException;
import java.io.InputStream;

/**
 * Mule input/output utilities.
 */
public class IOUtils {

  /**
   * This method wraps {@link org.apache.commons.io.IOUtils}' <code>toString(InputStream)</code> method but catches any
   * {@link IOException} and wraps it into a {@link RuntimeException}.
   */
  public static String toString(InputStream input) {
    try {
      return org.apache.commons.io.IOUtils.toString(input);
    } catch (IOException iox) {
      throw new RuntimeException(iox);
    }
  }

}
