/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.oauth.client.internal.config;

import org.mule.runtime.api.util.MultiMap;

import java.util.Map;

/**
 * Set of attributes needed to create client credentials dancer
 * {@link org.mule.oauth.client.internal.DefaultClientCredentialsOAuthDancer}.
 *
 * @since 1.0
 */
public class DefaultClientCredentialsOAuthDancerConfig extends OAuthDancerConfig {

  private MultiMap<String, String> customParameters;
  private MultiMap<String, String> customHeaders;
  private Map<String, String> customBodyParameters;

  public MultiMap<String, String> getCustomParameters() {
    return customParameters;
  }

  public void setCustomParameters(MultiMap<String, String> customParameters) {
    this.customParameters = customParameters;
  }

  public MultiMap<String, String> getCustomHeaders() {
    return customHeaders;
  }

  public Map<String, String> getCustomBodyParameters() {
    return customBodyParameters;
  }

  public void setCustomHeaders(MultiMap<String, String> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public void setCustomBodyParameters(Map<String, String> customBodyParameters) {
    this.customBodyParameters = customBodyParameters;
  }
}
