/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.gui.ResourcesTreeModel;
import bitronix.tm.resource.ResourceLoader;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.PropertyUtils;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;

public class ResourcesPanel
extends JPanel {
    private JSplitPane splitPane = new JSplitPane(1);
    private JTree resourcesTree = new JTree();
    private JScrollPane resourcesTreeScrollpane = new JScrollPane(this.resourcesTree);
    private JTextArea activeResource = new JTextArea();

    public ResourcesPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.resourcesTree.setModel(new ResourcesTreeModel());
        this.resourcesTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JTree tree = (JTree)evt.getSource();
                int selectedRow = tree.getSelectionRows()[0] - 1;
                ResourceLoader resourceLoader = TransactionManagerServices.getResourceLoader();
                Iterator<Map.Entry<String, XAResourceProducer>> it = resourceLoader.getResources().entrySet().iterator();
                ResourceBean resource = null;
                for (int i = 0; i < selectedRow + 1; ++i) {
                    Map.Entry<String, XAResourceProducer> entry = it.next();
                    resource = (ResourceBean)((Object)entry.getValue());
                }
                if (resource != null) {
                    try {
                        Map properties = PropertyUtils.getProperties(resource);
                        StringBuffer sb = new StringBuffer();
                        Iterator it2 = properties.entrySet().iterator();
                        while (it2.hasNext()) {
                            Map.Entry entry = it2.next();
                            String name = (String)entry.getKey();
                            Object valueObject = entry.getValue();
                            String value = valueObject == null ? null : valueObject.toString();
                            sb.append(name);
                            sb.append('=');
                            sb.append(value);
                            if (!it2.hasNext()) continue;
                            sb.append('\n');
                        }
                        ResourcesPanel.this.activeResource.setText(sb.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "error querying resource loader", "Error", 0);
                    }
                } else {
                    ResourcesPanel.this.activeResource.setText("");
                }
            }
        });
        this.splitPane.add(this.resourcesTreeScrollpane);
        this.splitPane.add(this.activeResource);
        this.add(this.splitPane);
    }
}

