/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.implv2.v10.model.ParameterImpl;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.internal.impl.v10.type.TypeId;

public class QueryStringImpl
implements QueryString {
    private TypeDeclaration typeDeclaration;
    private Collection<String> scalarTypes;

    public QueryStringImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        HashSet typeIds = Sets.newHashSet((Object[])TypeId.values());
        typeIds.remove(TypeId.OBJECT);
        typeIds.remove(TypeId.ARRAY);
        this.scalarTypes = Collections2.transform((Collection)typeIds, TypeId::getType);
    }

    public String getDefaultValue() {
        return this.typeDeclaration.defaultValue();
    }

    public boolean isArray() {
        return this.typeDeclaration instanceof ArrayTypeDeclaration;
    }

    public boolean validate(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty();
    }

    public boolean validate(Map<String, Collection<?>> queryParams) {
        String queryStringYaml = ParserUtils.queryStringAsYamlValue(this.facets(), queryParams);
        if (queryStringYaml.isEmpty()) {
            return this.validate("{}");
        }
        return this.validate(queryStringYaml);
    }

    public boolean isScalar() {
        return this.scalarTypes.contains(this.typeDeclaration.type());
    }

    public boolean isFacetArray(String facet) {
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                if (!type.name().equals(facet)) continue;
                return type instanceof ArrayTypeDeclaration;
            }
        }
        return false;
    }

    public Map<String, Parameter> facets() {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (TypeDeclaration type : this.getTypeDeclarations()) {
            if (!(type instanceof ObjectTypeDeclaration)) continue;
            for (TypeDeclaration prop : ((ObjectTypeDeclaration)type).properties()) {
                result.put(prop.name(), new ParameterImpl(prop));
            }
        }
        return result;
    }

    private List<TypeDeclaration> getTypeDeclarations() {
        if (this.typeDeclaration instanceof UnionTypeDeclaration) {
            return ((UnionTypeDeclaration)this.typeDeclaration).of();
        }
        if (this.typeDeclaration instanceof ArrayTypeDeclaration) {
            return Collections.singletonList(((ArrayTypeDeclaration)this.typeDeclaration).items());
        }
        return Collections.singletonList(this.typeDeclaration);
    }
}

