/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFElementClient;
import amf.core.client.common.validation.ValidationMode;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import org.mule.amf.impl.model.ValidationStrategy;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ParserUtils;

class YamlParameterValidationStrategy
extends ValidationStrategy {
    private AnyShape anyShape;
    private LazyValue<AMFShapePayloadValidator> parameterValidator;

    public YamlParameterValidationStrategy(AnyShape anyShape, boolean schemaNeedsQuotes, AMFElementClient amfElementClient) {
        super(schemaNeedsQuotes);
        this.anyShape = anyShape;
        this.parameterValidator = new LazyValue<AMFShapePayloadValidator>(() -> amfElementClient.payloadValidatorFor((Shape)anyShape, "application/yaml", ValidationMode.ScalarRelaxedValidationMode()));
    }

    @Override
    public boolean valueNeedQuotes(String value) {
        return this.schemaNeedsQuotes || value != null && value.startsWith("*");
    }

    @Override
    public boolean needsPreProcess(String value) {
        String trimmedValue = value.trim();
        return this.anyShape instanceof ArrayShape && !trimmedValue.startsWith("{") && !trimmedValue.startsWith("-");
    }

    @Override
    public AMFValidationReport validate(String value) {
        return this.parameterValidator.get().syncValidate(value == null ? "null" : value);
    }

    @Override
    public String escapeCharsInValue(String value) {
        return ParserUtils.escapeSpecialCharsInYamlValue((String)value);
    }

    @Override
    public String removeLeadingZeros(String value) {
        return value;
    }
}

