/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.model.domain.ArrayNode;
import amf.core.client.platform.model.domain.DataNode;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.ScalarNode;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.FileShape;
import amf.shapes.client.platform.model.domain.NilShape;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.ScalarShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.mule.amf.impl.exceptions.UnsupportedSchemaException;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.amf.impl.model.ParameterValidationStrategyFactory;
import org.mule.amf.impl.util.LazyValue;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.model.MetadataType;

class ParameterImpl
implements Parameter {
    private static final Set<String> NUMBER_DATA_TYPES = ImmutableSet.of((Object)"integer", (Object)"float", (Object)"number", (Object)"long", (Object)"double");
    public static final String BOOLEAN_DATA_TYPE = "boolean";
    private final ParameterValidationStrategy validationStrategy;
    private AnyShape schema;
    private Set<String> allowedEncoding;
    private boolean required;
    private LazyValue<List<String>> defaultValues;
    private LazyValue<Boolean> isArray = new LazyValue<Boolean>(() -> this.schema instanceof ArrayShape || this.schema instanceof UnionShape && ParameterImpl.hasAnArrayVariant((UnionShape)this.schema));
    private LazyValue<Boolean> isNullable = new LazyValue<Boolean>(() -> this.schema instanceof NilShape || this.schema instanceof UnionShape && ParameterImpl.hasNilShape((UnionShape)this.schema));

    ParameterImpl(amf.apicontract.client.platform.model.domain.Parameter parameter, AMFConfiguration amfConfiguration) {
        this(ParameterImpl.getSchema(parameter), parameter.required().value(), amfConfiguration);
    }

    ParameterImpl(PropertyShape property, AMFConfiguration amfConfiguration) {
        this(ParameterImpl.castToAnyShape(property.range()), property.minCount().value() > 0, amfConfiguration);
    }

    ParameterImpl(PropertyShape property, Set<String> allowedEncoding, AMFConfiguration amfConfiguration) {
        this(property, amfConfiguration);
        this.allowedEncoding = allowedEncoding;
    }

    ParameterImpl(AnyShape anyShape, boolean required, AMFConfiguration amfConfiguration) {
        this.schema = anyShape;
        this.required = required;
        this.validationStrategy = ParameterValidationStrategyFactory.getStrategy(anyShape, ParameterImpl.needsQuotes((Shape)anyShape), amfConfiguration.elementClient());
        this.defaultValues = new LazyValue<List>(() -> ParameterImpl.getDefaultValuesFromSchema(this.schema));
    }

    public boolean validate(String value) {
        return this.validatePayload(value).conforms();
    }

    AMFValidationReport validatePayload(String value) {
        return this.validationStrategy.validatePayload(value);
    }

    private static AnyShape getSchema(amf.apicontract.client.platform.model.domain.Parameter parameter) {
        Shape shape = parameter.schema();
        return ParameterImpl.castToAnyShape(shape);
    }

    private static AnyShape castToAnyShape(Shape shape) {
        if (shape instanceof AnyShape) {
            return (AnyShape)shape;
        }
        throw new UnsupportedSchemaException();
    }

    public String message(String value) {
        return this.getErrorMessageFromReport(this.validatePayload(value));
    }

    private String getErrorMessageFromReport(AMFValidationReport validationReport) {
        return validationReport.conforms() ? "OK" : validationReport.results().stream().map(AMFValidationResult::message).collect(Collectors.joining("\n"));
    }

    public String messageFromValues(Collection<?> values) {
        String arrayAsYamlValue = ParserUtils.getArrayAsYamlValue((Parameter)this, values);
        return this.getErrorMessageFromReport(this.validatePayload(arrayAsYamlValue));
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        List<String> defaultValues = this.getDefaultValues();
        return !defaultValues.isEmpty() ? defaultValues.get(0) : null;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues.get();
    }

    public boolean isRepeat() {
        return this.isArray.get();
    }

    public boolean isArray() {
        return this.isArray.get();
    }

    public boolean isNullable() {
        return this.isNullable.get();
    }

    public String getDisplayName() {
        return this.schema.displayName().value();
    }

    public String getDescription() {
        return this.schema.description().value();
    }

    public String getExample() {
        return this.schema.examples().stream().filter(example -> example.name().value() == null).map(example -> example.value().value()).findFirst().orElse(null);
    }

    public Map<String, String> getExamples() {
        return this.schema.examples().stream().filter(example -> example.name().value() != null).collect(Collectors.toMap(e -> e.name().value(), e -> e.value().value()));
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public MetadataType getMetadata() {
        throw new UnsupportedOperationException();
    }

    public boolean isScalar() {
        return this.schema instanceof ScalarShape;
    }

    public boolean isFacetArray(String facet) {
        if (this.schema instanceof NodeShape) {
            for (PropertyShape type : ((NodeShape)this.schema).properties()) {
                if (!facet.equals(type.name().value())) continue;
                return type.range() instanceof ArrayShape;
            }
        }
        return false;
    }

    public String surroundWithQuotesIfNeeded(String value) {
        return this.validationStrategy.preProcessValue(value);
    }

    public Optional<FileProperties> getFileProperties() {
        AnyShape shape = this.schema;
        if (shape instanceof ArrayShape) {
            shape = ((ArrayShape)shape).items();
        }
        if (shape instanceof FileShape) {
            FileShape fileShape = (FileShape)shape;
            return Optional.of(new FileProperties(Integer.valueOf(fileShape.minLength().value()), Integer.valueOf(fileShape.maxLength().value()), fileShape.fileTypes().stream().map(StrField::value).collect(Collectors.toSet())));
        }
        if (CollectionUtils.isNotEmpty(this.allowedEncoding)) {
            return Optional.of(new FileProperties(Integer.valueOf(0), Integer.valueOf(0), this.allowedEncoding));
        }
        return Optional.empty();
    }

    public boolean validateArray(Collection<?> values) {
        return this.validate(ParserUtils.getArrayAsYamlValue((Parameter)this, values));
    }

    private static Boolean needsQuotes(Shape anyShape) {
        ScalarShape scalarShape = null;
        if (anyShape instanceof ScalarShape) {
            scalarShape = (ScalarShape)anyShape;
        } else if (anyShape instanceof ArrayShape) {
            Shape itemsShape = ((ArrayShape)anyShape).items();
            scalarShape = itemsShape instanceof ScalarShape ? (ScalarShape)itemsShape : null;
        } else if (anyShape instanceof UnionShape) {
            return ((UnionShape)anyShape).anyOf().stream().anyMatch(shape -> ParameterImpl.needsQuotes(shape));
        }
        if (scalarShape == null) {
            return Boolean.FALSE;
        }
        String dataType = scalarShape.dataType().value();
        if (dataType == null) {
            return Boolean.FALSE;
        }
        return !NUMBER_DATA_TYPES.contains(dataType = dataType.substring(dataType.lastIndexOf(35) + 1)) && !BOOLEAN_DATA_TYPE.equals(dataType);
    }

    private static boolean hasAnArrayVariant(UnionShape unionShape) {
        return ParameterImpl.flatMapUnionShapes(unionShape).noneMatch(shape -> !(shape instanceof ArrayShape) && !(shape instanceof NilShape));
    }

    private static boolean hasNilShape(UnionShape unionShape) {
        return ParameterImpl.flatMapUnionShapes(unionShape).anyMatch(NilShape.class::isInstance);
    }

    private static Stream<Shape> flatMapUnionShapes(UnionShape unionShape) {
        return unionShape.anyOf().stream().flatMap(shape -> shape instanceof UnionShape ? ParameterImpl.flatMapUnionShapes((UnionShape)shape) : Stream.of(shape));
    }

    public static List<String> getDefaultValuesFromSchema(AnyShape schema) {
        DataNode dataNode = schema.defaultValue();
        if (dataNode == null) {
            return Collections.emptyList();
        }
        List<String> defaultValuesFromNode = ParameterImpl.getDefaultValuesFromNode(dataNode);
        if (defaultValuesFromNode.isEmpty()) {
            return ParameterImpl.getDefaultValueAsString(schema).map(v -> Arrays.asList(v)).orElse(Collections.emptyList());
        }
        return defaultValuesFromNode;
    }

    private static Optional<String> getDefaultValueAsString(AnyShape schema) {
        return Optional.ofNullable(schema.defaultValueStr().option().orElse(null));
    }

    private static List<String> getDefaultValuesFromNode(DataNode dataNode) {
        if (dataNode instanceof ScalarNode) {
            return Arrays.asList(((ScalarNode)dataNode).value().value());
        }
        if (dataNode instanceof ArrayNode) {
            List members = ((ArrayNode)dataNode).members();
            ArrayList<String> values = new ArrayList<String>();
            for (DataNode member : members) {
                values.addAll(ParameterImpl.getDefaultValuesFromNode(member));
            }
            return values;
        }
        return Collections.emptyList();
    }
}

