/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.apikit.validation.Severity;
import org.mule.parser.service.result.DefaultParsingIssue;
import org.mule.parser.service.result.ParsingIssue;

public class ValidationReportHelper {
    public static List<ParsingIssue> errors(ApiValidationReport report) {
        return ValidationReportHelper.getBySeverity(report, Severity.ERROR);
    }

    public static List<ParsingIssue> warnings(ApiValidationReport report) {
        return ValidationReportHelper.getBySeverity(report, Severity.WARNING);
    }

    private static List<ParsingIssue> getBySeverity(ApiValidationReport report, Severity severity) {
        return report.getResults().stream().filter(result -> severity.equals((Object)result.getSeverity())).map(result -> new DefaultParsingIssue(result.toString())).collect(Collectors.toList());
    }
}

