/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.annotations.Nullable;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;
import org.msgpack.jackson.dataformat.JavaInfo;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.MessagePackSerializedString;

public class MessagePackGenerator
extends GeneratorBase {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final int IN_ROOT = 0;
    private static final int IN_OBJECT = 1;
    private static final int IN_ARRAY = 2;
    private final MessagePacker messagePacker;
    private static final ThreadLocal<OutputStreamBufferOutput> messageBufferOutputHolder = new ThreadLocal();
    private final OutputStream output;
    private final MessagePack.PackerConfig packerConfig;
    private final boolean supportIntegerKeys;
    private int currentParentElementIndex = -1;
    private int currentState = 0;
    private final List<Node> nodes;
    private boolean isElementsClosed = false;

    private MessagePackGenerator(int n, ObjectCodec objectCodec, OutputStream outputStream, MessagePack.PackerConfig packerConfig, boolean bl) {
        super(n, objectCodec, new IOContext(new BufferRecycler(), ContentReference.rawReference((Object)outputStream), false), JsonWriteContext.createRootContext(null));
        this.output = outputStream;
        this.messagePacker = packerConfig.newPacker(outputStream);
        this.packerConfig = packerConfig;
        this.nodes = new ArrayList<Node>();
        this.supportIntegerKeys = bl;
    }

    public MessagePackGenerator(int n, ObjectCodec objectCodec, OutputStream outputStream, MessagePack.PackerConfig packerConfig, boolean bl, boolean bl2) throws IOException {
        super(n, objectCodec, new IOContext(new BufferRecycler(), ContentReference.rawReference((Object)outputStream), false), JsonWriteContext.createRootContext(null));
        this.output = outputStream;
        this.messagePacker = packerConfig.newPacker(this.getMessageBufferOutputForOutputStream(outputStream, bl));
        this.packerConfig = packerConfig;
        this.nodes = new ArrayList<Node>();
        this.supportIntegerKeys = bl2;
    }

    private MessageBufferOutput getMessageBufferOutputForOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        OutputStreamBufferOutput outputStreamBufferOutput;
        if (bl) {
            outputStreamBufferOutput = messageBufferOutputHolder.get();
            if (outputStreamBufferOutput == null) {
                outputStreamBufferOutput = new OutputStreamBufferOutput(outputStream);
                messageBufferOutputHolder.set(outputStreamBufferOutput);
            } else {
                outputStreamBufferOutput.reset(outputStream);
            }
        } else {
            outputStreamBufferOutput = new OutputStreamBufferOutput(outputStream);
        }
        return outputStreamBufferOutput;
    }

    private String currentStateStr() {
        switch (this.currentState) {
            case 1: {
                return "IN_OBJECT";
            }
            case 2: {
                return "IN_ARRAY";
            }
        }
        return "IN_ROOT";
    }

    public void writeStartArray() {
        if (this.currentState == 1) {
            Node node = this.nodes.get(this.nodes.size() - 1);
            assert (node instanceof NodeEntryInObject);
            NodeEntryInObject nodeEntryInObject = (NodeEntryInObject)node;
            nodeEntryInObject.value = new NodeArray(this.currentParentElementIndex);
        } else {
            this.nodes.add(new NodeArray(this.currentParentElementIndex));
        }
        this.currentParentElementIndex = this.nodes.size() - 1;
        this.currentState = 2;
    }

    public void writeEndArray() throws IOException {
        if (this.currentState != 2) {
            this._reportError("Current context not an array but " + this.currentStateStr());
        }
        this.endCurrentContainer();
    }

    public void writeStartObject() {
        if (this.currentState == 1) {
            Node node = this.nodes.get(this.nodes.size() - 1);
            assert (node instanceof NodeEntryInObject);
            NodeEntryInObject nodeEntryInObject = (NodeEntryInObject)node;
            nodeEntryInObject.value = new NodeObject(this.currentParentElementIndex);
        } else {
            this.nodes.add(new NodeObject(this.currentParentElementIndex));
        }
        this.currentParentElementIndex = this.nodes.size() - 1;
        this.currentState = 1;
    }

    public void writeEndObject() throws IOException {
        if (this.currentState != 1) {
            this._reportError("Current context not an object but " + this.currentStateStr());
        }
        this.endCurrentContainer();
    }

    private void endCurrentContainer() {
        Node node = this.nodes.get(this.currentParentElementIndex);
        if (this.currentParentElementIndex == 0) {
            this.isElementsClosed = true;
            this.currentParentElementIndex = node.parentIndex;
            return;
        }
        this.currentParentElementIndex = node.parentIndex;
        assert (this.currentParentElementIndex >= 0);
        Node node2 = this.nodes.get(this.currentParentElementIndex);
        node2.incrementChildCount();
        this.currentState = node2.currentStateAsParent();
    }

    private void packNonContainer(Object object) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        if (object instanceof String) {
            messagePacker.packString((String)object);
        } else if (object instanceof AsciiCharString) {
            byte[] byArray = ((AsciiCharString)object).bytes;
            messagePacker.packRawStringHeader(byArray.length);
            messagePacker.writePayload(byArray);
        } else if (object instanceof Integer) {
            messagePacker.packInt(((Integer)object).intValue());
        } else if (object == null) {
            messagePacker.packNil();
        } else if (object instanceof Float) {
            messagePacker.packFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            messagePacker.packLong(((Long)object).longValue());
        } else if (object instanceof Double) {
            messagePacker.packDouble(((Double)object).doubleValue());
        } else if (object instanceof BigInteger) {
            messagePacker.packBigInteger((BigInteger)object);
        } else if (object instanceof BigDecimal) {
            this.packBigDecimal((BigDecimal)object);
        } else if (object instanceof Boolean) {
            messagePacker.packBoolean(((Boolean)object).booleanValue());
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            int n = byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                messagePacker.packBinaryHeader(n);
                messagePacker.writePayload(byteBuffer.array(), byteBuffer.arrayOffset(), n);
            } else {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                messagePacker.packBinaryHeader(n);
                messagePacker.addPayload(byArray);
            }
        } else if (object instanceof MessagePackExtensionType) {
            MessagePackExtensionType messagePackExtensionType = (MessagePackExtensionType)object;
            byte[] byArray = messagePackExtensionType.getData();
            messagePacker.packExtensionTypeHeader(messagePackExtensionType.getType(), byArray.length);
            messagePacker.writePayload(byArray);
        } else {
            messagePacker.flush();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MessagePackGenerator messagePackGenerator = new MessagePackGenerator(this.getFeatureMask(), this.getCodec(), byteArrayOutputStream, this.packerConfig, this.supportIntegerKeys);
            this.getCodec().writeValue((JsonGenerator)messagePackGenerator, object);
            this.output.write(byteArrayOutputStream.toByteArray());
        }
    }

    private void packBigDecimal(BigDecimal bigDecimal) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        boolean bl = false;
        try {
            BigInteger bigInteger = bigDecimal.toBigIntegerExact();
            messagePacker.packBigInteger(bigInteger);
        }
        catch (ArithmeticException | IllegalArgumentException runtimeException) {
            bl = true;
        }
        if (bl) {
            double d = bigDecimal.doubleValue();
            if (!bigDecimal.stripTrailingZeros().toEngineeringString().equals(BigDecimal.valueOf(d).stripTrailingZeros().toEngineeringString())) {
                throw new IllegalArgumentException("MessagePack cannot serialize a BigDecimal that can't be represented as double. " + bigDecimal);
            }
            messagePacker.packDouble(d);
        }
    }

    private void packObject(NodeObject nodeObject) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.packMapHeader(nodeObject.childCount);
    }

    private void packArray(NodeArray nodeArray) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.packArrayHeader(nodeArray.childCount);
    }

    private void addKeyNode(Object object) {
        if (this.currentState != 1) {
            throw new IllegalStateException();
        }
        NodeEntryInObject nodeEntryInObject = new NodeEntryInObject(this.currentParentElementIndex, object);
        this.nodes.add(nodeEntryInObject);
    }

    private void addValueNode(Object object) throws IOException {
        switch (this.currentState) {
            case 1: {
                Node node = this.nodes.get(this.nodes.size() - 1);
                assert (node instanceof NodeEntryInObject);
                NodeEntryInObject nodeEntryInObject = (NodeEntryInObject)node;
                nodeEntryInObject.value = object;
                this.nodes.get(node.parentIndex).incrementChildCount();
                break;
            }
            case 2: {
                NodeEntryInArray nodeEntryInArray = new NodeEntryInArray(this.currentParentElementIndex, object);
                this.nodes.add(nodeEntryInArray);
                this.nodes.get(nodeEntryInArray.parentIndex).incrementChildCount();
                break;
            }
            default: {
                this.packNonContainer(object);
                this.flushMessagePacker();
            }
        }
    }

    @Nullable
    private byte[] getBytesIfAscii(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = n; i < n + n2; ++i) {
            char c = cArray[i];
            if (c >= '\u0080') {
                return null;
            }
            byArray[i] = (byte)c;
        }
        return byArray;
    }

    private boolean areAllAsciiBytes(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if ((byArray[i] & 0x80) == 0) continue;
            return false;
        }
        return true;
    }

    private void writeCharArrayTextKey(char[] cArray, int n, int n2) {
        byte[] byArray = this.getBytesIfAscii(cArray, n, n2);
        if (byArray != null) {
            this.addKeyNode(new AsciiCharString(byArray));
            return;
        }
        this.addKeyNode(new String(cArray, n, n2));
    }

    private void writeCharArrayTextValue(char[] cArray, int n, int n2) throws IOException {
        byte[] byArray = this.getBytesIfAscii(cArray, n, n2);
        if (byArray != null) {
            this.addValueNode(new AsciiCharString(byArray));
            return;
        }
        this.addValueNode(new String(cArray, n, n2));
    }

    private void writeByteArrayTextValue(byte[] byArray, int n, int n2) throws IOException {
        if (this.areAllAsciiBytes(byArray, n, n2)) {
            this.addValueNode(new AsciiCharString(byArray));
            return;
        }
        this.addValueNode(new String(byArray, n, n2, DEFAULT_CHARSET));
    }

    private void writeByteArrayTextKey(byte[] byArray, int n, int n2) throws IOException {
        if (this.areAllAsciiBytes(byArray, n, n2)) {
            this.addValueNode(new AsciiCharString(byArray));
            return;
        }
        this.addValueNode(new String(byArray, n, n2, DEFAULT_CHARSET));
    }

    public void writeFieldId(long l) throws IOException {
        if (this.supportIntegerKeys) {
            this.addKeyNode(l);
        } else {
            super.writeFieldId(l);
        }
    }

    public void writeFieldName(String string) {
        if (JavaInfo.STRING_VALUE_FIELD_IS_CHARS.get().booleanValue()) {
            char[] cArray = string.toCharArray();
            this.writeCharArrayTextKey(cArray, 0, cArray.length);
        } else {
            this.addKeyNode(string);
        }
    }

    public void writeFieldName(SerializableString serializableString) {
        if (serializableString instanceof SerializedString) {
            this.writeFieldName(serializableString.getValue());
        } else if (serializableString instanceof MessagePackSerializedString) {
            this.addKeyNode(((MessagePackSerializedString)serializableString).getRawValue());
        } else {
            throw new IllegalArgumentException("Unsupported key: " + serializableString);
        }
    }

    public void writeString(String string) throws IOException {
        if (JavaInfo.STRING_VALUE_FIELD_IS_CHARS.get().booleanValue()) {
            char[] cArray = string.toCharArray();
            this.writeCharArrayTextValue(cArray, 0, cArray.length);
        } else {
            this.addValueNode(string);
        }
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException {
        this.writeCharArrayTextValue(cArray, n, n2);
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this.writeByteArrayTextValue(byArray, n, n2);
    }

    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this.writeByteArrayTextValue(byArray, n, n2);
    }

    public void writeRaw(String string) throws IOException {
        if (JavaInfo.STRING_VALUE_FIELD_IS_CHARS.get().booleanValue()) {
            char[] cArray = string.toCharArray();
            this.writeCharArrayTextValue(cArray, 0, cArray.length);
        } else {
            this.addValueNode(string);
        }
    }

    public void writeRaw(String string, int n, int n2) throws IOException {
        char[] cArray = string.toCharArray();
        this.writeCharArrayTextValue(cArray, n, n2);
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException {
        this.writeCharArrayTextValue(cArray, n, n2);
    }

    public void writeRaw(char c) throws IOException {
        this.writeCharArrayTextValue(new char[]{c}, 0, 1);
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException {
        this.addValueNode(ByteBuffer.wrap(byArray, n, n2));
    }

    public void writeNumber(int n) throws IOException {
        this.addValueNode(n);
    }

    public void writeNumber(long l) throws IOException {
        this.addValueNode(l);
    }

    public void writeNumber(BigInteger bigInteger) throws IOException {
        this.addValueNode(bigInteger);
    }

    public void writeNumber(double d) throws IOException {
        this.addValueNode(d);
    }

    public void writeNumber(float f) throws IOException {
        this.addValueNode(Float.valueOf(f));
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        this.addValueNode(bigDecimal);
    }

    public void writeNumber(String string) throws IOException, UnsupportedOperationException {
        try {
            long l = Long.parseLong(string);
            this.addValueNode(l);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string);
                this.addValueNode(d);
                return;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    BigInteger bigInteger = new BigInteger(string);
                    this.addValueNode(bigInteger);
                    return;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.addValueNode(bigDecimal);
                        return;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        throw new NumberFormatException(string);
                    }
                }
            }
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.addValueNode(bl);
    }

    public void writeNull() throws IOException {
        this.addValueNode(null);
    }

    public void writeExtensionType(MessagePackExtensionType messagePackExtensionType) throws IOException {
        this.addValueNode(messagePackExtensionType);
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                MessagePacker messagePacker = this.getMessagePacker();
                messagePacker.close();
            }
        }
    }

    public void flush() throws IOException {
        if (!this.isElementsClosed) {
            return;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = this.nodes.get(i);
            if (node instanceof NodeEntryInObject) {
                NodeEntryInObject nodeEntryInObject = (NodeEntryInObject)node;
                this.packNonContainer(nodeEntryInObject.key);
                if (nodeEntryInObject.value instanceof NodeObject) {
                    this.packObject((NodeObject)nodeEntryInObject.value);
                    continue;
                }
                if (nodeEntryInObject.value instanceof NodeArray) {
                    this.packArray((NodeArray)nodeEntryInObject.value);
                    continue;
                }
                this.packNonContainer(nodeEntryInObject.value);
                continue;
            }
            if (node instanceof NodeObject) {
                this.packObject((NodeObject)node);
                continue;
            }
            if (node instanceof NodeEntryInArray) {
                this.packNonContainer(((NodeEntryInArray)node).value);
                continue;
            }
            if (node instanceof NodeArray) {
                this.packArray((NodeArray)node);
                continue;
            }
            throw new AssertionError();
        }
        this.flushMessagePacker();
        this.nodes.clear();
        this.isElementsClosed = false;
    }

    private void flushMessagePacker() throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.flush();
    }

    protected void _releaseBuffers() {
        try {
            this.messagePacker.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to close MessagePacker", iOException);
        }
    }

    protected void _verifyValueWrite(String string) throws IOException {
    }

    private MessagePacker getMessagePacker() {
        return this.messagePacker;
    }

    private static final class NodeEntryInObject
    extends Node {
        final Object key;
        Object value;

        public NodeEntryInObject(int n, Object object) {
            super(n);
            this.key = object;
        }

        @Override
        void incrementChildCount() {
            assert (this.value instanceof NodeContainer);
            ++((NodeContainer)this.value).childCount;
        }

        @Override
        int currentStateAsParent() {
            if (this.value instanceof NodeObject) {
                return 1;
            }
            if (this.value instanceof NodeArray) {
                return 2;
            }
            throw new AssertionError();
        }
    }

    private static final class NodeEntryInArray
    extends Node {
        final Object value;

        public NodeEntryInArray(int n, Object object) {
            super(n);
            this.value = object;
        }

        @Override
        void incrementChildCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        int currentStateAsParent() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class NodeObject
    extends NodeContainer {
        public NodeObject(int n) {
            super(n);
        }

        @Override
        int currentStateAsParent() {
            return 1;
        }
    }

    private static final class NodeArray
    extends NodeContainer {
        public NodeArray(int n) {
            super(n);
        }

        @Override
        int currentStateAsParent() {
            return 2;
        }
    }

    private static abstract class NodeContainer
    extends Node {
        int childCount;

        public NodeContainer(int n) {
            super(n);
        }

        @Override
        void incrementChildCount() {
            ++this.childCount;
        }
    }

    private static abstract class Node {
        final int parentIndex;

        public Node(int n) {
            this.parentIndex = n;
        }

        abstract void incrementChildCount();

        abstract int currentStateAsParent();
    }

    private static final class AsciiCharString {
        public final byte[] bytes;

        public AsciiCharString(byte[] byArray) {
            this.bytes = byArray;
        }
    }
}

