/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.GeneratorBase;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.msgpack.core.buffer.OutputStreamBufferOutput;

public class MessagePackGenerator
extends GeneratorBase {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static ThreadLocal<MessagePacker> messagePackersHolder = new ThreadLocal();
    private static ThreadLocal<OutputStreamBufferOutput> messageBufferOutputHolder = new ThreadLocal();
    private LinkedList<StackItem> stack;
    private StackItem rootStackItem;

    public MessagePackGenerator(int n, ObjectCodec objectCodec, OutputStream outputStream) throws IOException {
        super(n, objectCodec);
        MessagePacker messagePacker = messagePackersHolder.get();
        OutputStreamBufferOutput outputStreamBufferOutput = messageBufferOutputHolder.get();
        if (outputStreamBufferOutput == null) {
            outputStreamBufferOutput = new OutputStreamBufferOutput(outputStream);
        } else {
            outputStreamBufferOutput.reset(outputStream);
        }
        messageBufferOutputHolder.set(outputStreamBufferOutput);
        if (messagePacker == null) {
            messagePacker = new MessagePacker((MessageBufferOutput)outputStreamBufferOutput);
        } else {
            messagePacker.reset((MessageBufferOutput)outputStreamBufferOutput);
        }
        messagePackersHolder.set(messagePacker);
        this.stack = new LinkedList();
    }

    public void writeStartArray() throws IOException, JsonGenerationException {
        this._writeContext = this._writeContext.createChildArrayContext();
        this.stack.push(new StackItemForArray());
    }

    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an array but " + this._writeContext.getTypeDesc());
        }
        this.getStackTopForArray();
        this._writeContext = this._writeContext.getParent();
        this.popStackAndStoreTheItemAsValue();
    }

    public void writeStartObject() throws IOException, JsonGenerationException {
        this._writeContext = this._writeContext.createChildObjectContext();
        this.stack.push(new StackItemForObject());
    }

    public void writeEndObject() throws IOException, JsonGenerationException {
        StackItemForObject stackItemForObject;
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if ((stackItemForObject = this.getStackTopForObject()).getKeys().size() != stackItemForObject.getValues().size()) {
            throw new IllegalStateException(String.format("objectKeys.size() and objectValues.size() is not same: depth=%d, key=%d, value=%d", this.stack.size(), stackItemForObject.getKeys().size(), stackItemForObject.getValues().size()));
        }
        this._writeContext = this._writeContext.getParent();
        this.popStackAndStoreTheItemAsValue();
    }

    private void packValue(Object object) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        if (object == null) {
            messagePacker.packNil();
        } else if (object instanceof Integer) {
            messagePacker.packInt(((Integer)object).intValue());
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            messagePacker.packBinaryHeader(byteBuffer.limit());
            messagePacker.writePayload(byteBuffer);
        } else if (object instanceof String) {
            messagePacker.packString((String)object);
        } else if (object instanceof Float) {
            messagePacker.packFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            messagePacker.packLong(((Long)object).longValue());
        } else if (object instanceof StackItemForObject) {
            this.packObject((StackItemForObject)object);
        } else if (object instanceof StackItemForArray) {
            this.packArray((StackItemForArray)object);
        } else if (object instanceof Double) {
            messagePacker.packDouble(((Double)object).doubleValue());
        } else if (object instanceof BigInteger) {
            messagePacker.packBigInteger((BigInteger)object);
        } else if (object instanceof BigDecimal) {
            this.packBigDecimal((BigDecimal)object);
        } else if (object instanceof Boolean) {
            messagePacker.packBoolean(((Boolean)object).booleanValue());
        } else {
            throw new IllegalArgumentException(object.toString());
        }
    }

    private void packBigDecimal(BigDecimal bigDecimal) throws IOException {
        MessagePacker messagePacker = this.getMessagePacker();
        boolean bl = false;
        try {
            BigInteger bigInteger = bigDecimal.toBigIntegerExact();
            messagePacker.packBigInteger(bigInteger);
        }
        catch (ArithmeticException arithmeticException) {
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        if (bl) {
            double d = bigDecimal.doubleValue();
            if (!bigDecimal.toEngineeringString().equals(BigDecimal.valueOf(d).toEngineeringString())) {
                throw new IllegalArgumentException("MessagePack cannot serialize a BigDecimal that can't be represented as double. " + bigDecimal);
            }
            messagePacker.packDouble(d);
        }
    }

    private void packObject(StackItemForObject stackItemForObject) throws IOException {
        List<String> list = stackItemForObject.getKeys();
        List<Object> list2 = stackItemForObject.getValues();
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.packMapHeader(list.size());
        for (int i = 0; i < list.size(); ++i) {
            messagePacker.packString(list.get(i));
            Object object = list2.get(i);
            this.packValue(object);
        }
    }

    private void packArray(StackItemForArray stackItemForArray) throws IOException {
        List<Object> list = stackItemForArray.getValues();
        MessagePacker messagePacker = this.getMessagePacker();
        messagePacker.packArrayHeader(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            this.packValue(object);
        }
    }

    public void writeFieldName(String string) throws IOException, JsonGenerationException {
        this.addKeyToStackTop(string);
    }

    public void writeString(String string) throws IOException, JsonGenerationException {
        this.addValueToStackTop(string);
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(cArray, n, n2));
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(byArray, n, n2, DEFAULT_CHARSET));
    }

    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(byArray, n, n2, DEFAULT_CHARSET));
    }

    public void writeRaw(String string) throws IOException, JsonGenerationException {
        this.addValueToStackTop(string);
    }

    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(string.substring(0, n2));
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(new String(cArray, n, n2));
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.addValueToStackTop(String.valueOf(c));
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this.addValueToStackTop(ByteBuffer.wrap(byArray, n, n2));
    }

    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this.addValueToStackTop(n);
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this.addValueToStackTop(l);
    }

    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this.addValueToStackTop(bigInteger);
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this.addValueToStackTop(d);
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.addValueToStackTop(Float.valueOf(f));
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this.addValueToStackTop(bigDecimal);
    }

    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        throw new UnsupportedOperationException("writeNumber(String encodedValue) isn't supported yet");
    }

    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this.addValueToStackTop(bl);
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this.addValueToStackTop(null);
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            MessagePacker messagePacker = this.getMessagePacker();
            messagePacker.close();
        }
    }

    public void flush() throws IOException {
        if (this.rootStackItem != null) {
            if (this.rootStackItem instanceof StackItemForObject) {
                this.packObject((StackItemForObject)this.rootStackItem);
            } else if (this.rootStackItem instanceof StackItemForArray) {
                this.packArray((StackItemForArray)this.rootStackItem);
            } else {
                throw new IllegalStateException("Unexpected rootStackItem: " + this.rootStackItem);
            }
            this.rootStackItem = null;
            MessagePacker messagePacker = this.getMessagePacker();
            messagePacker.flush();
        }
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    private StackItem getStackTop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("The stack is empty");
        }
        return this.stack.getFirst();
    }

    private StackItemForObject getStackTopForObject() {
        StackItem stackItem = this.getStackTop();
        if (!(stackItem instanceof StackItemForObject)) {
            throw new IllegalStateException("The stack top should be Object: " + stackItem);
        }
        return (StackItemForObject)stackItem;
    }

    private StackItemForArray getStackTopForArray() {
        StackItem stackItem = this.getStackTop();
        if (!(stackItem instanceof StackItemForArray)) {
            throw new IllegalStateException("The stack top should be Array: " + stackItem);
        }
        return (StackItemForArray)stackItem;
    }

    private void addKeyToStackTop(String string) {
        this.getStackTop().addKey(string);
    }

    private void addValueToStackTop(Object object) {
        this.getStackTop().addValue(object);
    }

    private void popStackAndStoreTheItemAsValue() {
        StackItem stackItem = this.stack.pop();
        if (this.stack.size() > 0) {
            this.addValueToStackTop(stackItem);
        } else {
            if (this.rootStackItem != null) {
                throw new IllegalStateException("rootStackItem is not null");
            }
            this.rootStackItem = stackItem;
        }
    }

    private MessagePacker getMessagePacker() {
        MessagePacker messagePacker = messagePackersHolder.get();
        if (messagePacker == null) {
            throw new IllegalStateException("messagePacker is null");
        }
        return messagePacker;
    }

    private static class StackItemForArray
    extends StackItem {
        private StackItemForArray() {
        }

        @Override
        void addKey(String string) {
            throw new IllegalStateException("This method shouldn't be called");
        }

        @Override
        List<String> getKeys() {
            throw new IllegalStateException("This method shouldn't be called");
        }
    }

    private static class StackItemForObject
    extends StackItem {
        private StackItemForObject() {
        }

        @Override
        void addKey(String string) {
            this.objectKeys.add(string);
        }

        @Override
        List<String> getKeys() {
            return this.objectKeys;
        }
    }

    private static abstract class StackItem {
        protected List<String> objectKeys = new ArrayList<String>();
        protected List<Object> objectValues = new ArrayList<Object>();

        private StackItem() {
        }

        abstract void addKey(String var1);

        void addValue(Object object) {
            this.objectValues.add(object);
        }

        abstract List<String> getKeys();

        List<Object> getValues() {
            return this.objectValues;
        }
    }
}

