/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import org.msgpack.jackson.dataformat.MessagePackGenerator;
import org.msgpack.jackson.dataformat.MessagePackParser;

public class MessagePackFactory
extends JsonFactory {
    private static final long serialVersionUID = 2578263992015504347L;

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return new MessagePackGenerator(this._generatorFeatures, this._objectCodec, outputStream);
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(new FileOutputStream(file), jsonEncoding);
    }

    public JsonGenerator createGenerator(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public JsonParser createParser(byte[] byArray) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(byArray, false);
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    public JsonParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(inputStream, false);
        return this._createParser(inputStream, iOContext);
    }

    protected MessagePackParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        MessagePackParser messagePackParser = new MessagePackParser(iOContext, this._parserFeatures, inputStream);
        return messagePackParser;
    }

    protected JsonParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        if (n != 0 || n2 != byArray.length) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
        }
        MessagePackParser messagePackParser = new MessagePackParser(iOContext, this._parserFeatures, byArray);
        return messagePackParser;
    }
}

