/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.output.mp4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part12.ChunkOffsetBox;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleSizeBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SampleToChunkBox;
import org.mp4parser.boxes.iso14496.part12.SyncSampleBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.streaming.StreamingSample;
import org.mp4parser.streaming.StreamingTrack;
import org.mp4parser.streaming.extensions.CompositionTimeSampleExtension;
import org.mp4parser.streaming.extensions.CompositionTimeTrackExtension;
import org.mp4parser.streaming.extensions.SampleFlagsSampleExtension;
import org.mp4parser.streaming.extensions.TrackIdTrackExtension;
import org.mp4parser.streaming.output.SampleSink;
import org.mp4parser.streaming.output.mp4.DefaultBoxes;
import org.mp4parser.streaming.output.mp4.FragmentedMp4Writer;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Mp4Arrays;
import org.mp4parser.tools.Mp4Math;
import org.mp4parser.tools.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMp4Writer
extends DefaultBoxes
implements SampleSink {
    public static final Object OBJ = new Object();
    private static Logger LOG = LoggerFactory.getLogger((String)FragmentedMp4Writer.class.getName());
    protected final WritableByteChannel sink;
    protected List<StreamingTrack> source;
    protected Date creationTime = new Date();
    protected Map<StreamingTrack, CountDownLatch> congestionControl = new ConcurrentHashMap<StreamingTrack, CountDownLatch>();
    protected Map<StreamingTrack, Long> nextChunkCreateStartTime = new ConcurrentHashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, Long> nextChunkWriteStartTime = new ConcurrentHashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, Long> nextSampleStartTime = new HashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, List<StreamingSample>> sampleBuffers = new HashMap<StreamingTrack, List<StreamingSample>>();
    protected Map<StreamingTrack, TrackBox> trackBoxes = new HashMap<StreamingTrack, TrackBox>();
    protected Map<StreamingTrack, Queue<ChunkContainer>> chunkBuffers = new ConcurrentHashMap<StreamingTrack, Queue<ChunkContainer>>();
    protected Map<StreamingTrack, Long> chunkNumbers = new HashMap<StreamingTrack, Long>();
    protected Map<StreamingTrack, Long> sampleNumbers = new HashMap<StreamingTrack, Long>();
    long bytesWritten = 0L;
    volatile boolean headerWritten = false;

    public StandardMp4Writer(List<StreamingTrack> source, WritableByteChannel sink) {
        this.source = new ArrayList<StreamingTrack>(source);
        this.sink = sink;
        HashSet<Long> trackIds = new HashSet<Long>();
        for (StreamingTrack streamingTrack : source) {
            streamingTrack.setSampleSink(this);
            this.chunkNumbers.put(streamingTrack, 1L);
            this.sampleNumbers.put(streamingTrack, 1L);
            this.nextSampleStartTime.put(streamingTrack, 0L);
            this.nextChunkCreateStartTime.put(streamingTrack, 0L);
            this.nextChunkWriteStartTime.put(streamingTrack, 0L);
            this.congestionControl.put(streamingTrack, new CountDownLatch(0));
            this.sampleBuffers.put(streamingTrack, new ArrayList());
            this.chunkBuffers.put(streamingTrack, new LinkedList());
            if (streamingTrack.getTrackExtension(TrackIdTrackExtension.class) == null) continue;
            TrackIdTrackExtension trackIdTrackExtension = streamingTrack.getTrackExtension(TrackIdTrackExtension.class);
            assert (trackIdTrackExtension != null);
            if (!trackIds.contains(trackIdTrackExtension.getTrackId())) continue;
            throw new RuntimeException("There may not be two tracks with the same trackID within one file");
        }
        for (StreamingTrack streamingTrack : source) {
            if (streamingTrack.getTrackExtension(TrackIdTrackExtension.class) != null) continue;
            long maxTrackId = 0L;
            for (Long trackId : trackIds) {
                maxTrackId = Math.max(trackId, maxTrackId);
            }
            TrackIdTrackExtension tiExt = new TrackIdTrackExtension(maxTrackId + 1L);
            trackIds.add(tiExt.getTrackId());
            streamingTrack.addTrackExtension(tiExt);
        }
    }

    @Override
    public void close() throws IOException {
        for (StreamingTrack streamingTrack : this.source) {
            this.writeChunkContainer(this.createChunkContainer(streamingTrack));
            streamingTrack.close();
        }
        this.write(this.sink, this.createMoov());
    }

    protected Box createMoov() {
        MovieBox movieBox = new MovieBox();
        movieBox.addBox(this.createMvhd());
        for (StreamingTrack streamingTrack : this.source) {
            movieBox.addBox((Box)this.trackBoxes.get(streamingTrack));
        }
        return movieBox;
    }

    private void sortTracks() {
        Collections.sort(this.source, new Comparator<StreamingTrack>(){

            @Override
            public int compare(StreamingTrack o1, StreamingTrack o2) {
                long a = StandardMp4Writer.this.nextChunkWriteStartTime.get(o1) * o2.getTimescale();
                long b = StandardMp4Writer.this.nextChunkWriteStartTime.get(o2) * o1.getTimescale();
                double d = Math.signum(a - b);
                return (int)d;
            }
        });
    }

    @Override
    protected Box createMvhd() {
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setVersion(1);
        mvhd.setCreationTime(this.creationTime);
        mvhd.setModificationTime(this.creationTime);
        long[] timescales = new long[]{};
        long maxTrackId = 0L;
        double duration = 0.0;
        for (StreamingTrack streamingTrack : this.source) {
            duration = Math.max((double)this.nextSampleStartTime.get(streamingTrack).longValue() / (double)streamingTrack.getTimescale(), duration);
            timescales = Mp4Arrays.copyOfAndAppend((long[])timescales, (long[])new long[]{streamingTrack.getTimescale()});
            maxTrackId = Math.max(streamingTrack.getTrackExtension(TrackIdTrackExtension.class).getTrackId(), maxTrackId);
        }
        mvhd.setTimescale(Mp4Math.lcm((long[])timescales));
        mvhd.setDuration((long)((double)Mp4Math.lcm((long[])timescales) * duration));
        mvhd.setNextTrackId(maxTrackId + 1L);
        return mvhd;
    }

    protected void write(WritableByteChannel out, Box ... boxes) throws IOException {
        for (Box box1 : boxes) {
            box1.getBox(out);
            this.bytesWritten += box1.getSize();
        }
    }

    protected boolean isChunkReady(StreamingTrack streamingTrack, StreamingSample next) {
        long cfst;
        long ts = this.nextSampleStartTime.get(streamingTrack);
        return ts >= (cfst = this.nextChunkCreateStartTime.get(streamingTrack).longValue()) + 2L * streamingTrack.getTimescale();
    }

    protected void writeChunkContainer(ChunkContainer chunkContainer) throws IOException {
        TrackBox tb = this.trackBoxes.get(chunkContainer.streamingTrack);
        ChunkOffsetBox stco = (ChunkOffsetBox)Path.getPath((AbstractContainerBox)tb, (String)"mdia[0]/minf[0]/stbl[0]/stco[0]");
        assert (stco != null);
        stco.setChunkOffsets(Mp4Arrays.copyOfAndAppend((long[])stco.getChunkOffsets(), (long[])new long[]{this.bytesWritten + 8L}));
        this.write(this.sink, chunkContainer.mdat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptSample(StreamingSample streamingSample, StreamingTrack streamingTrack) throws IOException {
        TrackBox tb = this.trackBoxes.get(streamingTrack);
        if (tb == null) {
            tb = new TrackBox();
            tb.addBox(this.createTkhd(streamingTrack));
            tb.addBox(this.createMdia(streamingTrack));
            this.trackBoxes.put(streamingTrack, tb);
        }
        Object object = OBJ;
        synchronized (object) {
            if (!this.headerWritten) {
                boolean allTracksAtLeastOneSample = true;
                for (StreamingTrack track : this.source) {
                    allTracksAtLeastOneSample &= this.nextSampleStartTime.get(track) > 0L || track == streamingTrack;
                }
                if (allTracksAtLeastOneSample) {
                    this.write(this.sink, this.createFtyp());
                    this.headerWritten = true;
                }
            }
        }
        try {
            CountDownLatch cdl = this.congestionControl.get(streamingTrack);
            if (cdl.getCount() > 0L) {
                cdl.await();
            }
        }
        catch (InterruptedException cdl) {
            // empty catch block
        }
        if (this.isChunkReady(streamingTrack, streamingSample)) {
            ChunkContainer chunkContainer = this.createChunkContainer(streamingTrack);
            this.sampleBuffers.get(streamingTrack).clear();
            this.nextChunkCreateStartTime.put(streamingTrack, this.nextChunkCreateStartTime.get(streamingTrack) + chunkContainer.duration);
            Queue<ChunkContainer> chunkQueue = this.chunkBuffers.get(streamingTrack);
            chunkQueue.add(chunkContainer);
            Object object2 = OBJ;
            synchronized (object2) {
                if (this.headerWritten && this.source.get(0) == streamingTrack) {
                    StreamingTrack currentStreamingTrack;
                    Queue<ChunkContainer> tracksFragmentQueue;
                    while (!(tracksFragmentQueue = this.chunkBuffers.get(currentStreamingTrack = this.source.get(0))).isEmpty()) {
                        ChunkContainer currentFragmentContainer = tracksFragmentQueue.remove();
                        this.writeChunkContainer(currentFragmentContainer);
                        this.congestionControl.get(currentStreamingTrack).countDown();
                        long ts = this.nextChunkWriteStartTime.get(currentStreamingTrack) + currentFragmentContainer.duration;
                        this.nextChunkWriteStartTime.put(currentStreamingTrack, ts);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace(currentStreamingTrack + " advanced to " + (double)ts / (double)currentStreamingTrack.getTimescale());
                        }
                        this.sortTracks();
                    }
                } else if (chunkQueue.size() > 10) {
                    this.congestionControl.put(streamingTrack, new CountDownLatch(chunkQueue.size()));
                }
            }
        }
        this.sampleBuffers.get(streamingTrack).add(streamingSample);
        this.nextSampleStartTime.put(streamingTrack, this.nextSampleStartTime.get(streamingTrack) + streamingSample.getDuration());
    }

    private ChunkContainer createChunkContainer(StreamingTrack streamingTrack) {
        List<StreamingSample> samples = this.sampleBuffers.get(streamingTrack);
        long chunkNumber = this.chunkNumbers.get(streamingTrack);
        this.chunkNumbers.put(streamingTrack, chunkNumber + 1L);
        ChunkContainer cc = new ChunkContainer();
        cc.streamingTrack = streamingTrack;
        cc.mdat = new Mdat(samples);
        cc.duration = this.nextSampleStartTime.get(streamingTrack) - this.nextChunkCreateStartTime.get(streamingTrack);
        TrackBox tb = this.trackBoxes.get(streamingTrack);
        SampleTableBox stbl = (SampleTableBox)Path.getPath((AbstractContainerBox)tb, (String)"mdia[0]/minf[0]/stbl[0]");
        assert (stbl != null);
        SampleToChunkBox stsc = (SampleToChunkBox)Path.getPath((AbstractContainerBox)stbl, (String)"stsc[0]");
        assert (stsc != null);
        if (stsc.getEntries().isEmpty()) {
            ArrayList<SampleToChunkBox.Entry> entries = new ArrayList<SampleToChunkBox.Entry>();
            stsc.setEntries(entries);
            entries.add(new SampleToChunkBox.Entry(chunkNumber, (long)samples.size(), 1L));
        } else {
            SampleToChunkBox.Entry e = (SampleToChunkBox.Entry)stsc.getEntries().get(stsc.getEntries().size() - 1);
            if (e.getSamplesPerChunk() != (long)samples.size()) {
                stsc.getEntries().add(new SampleToChunkBox.Entry(chunkNumber, (long)samples.size(), 1L));
            }
        }
        long sampleNumber = this.sampleNumbers.get(streamingTrack);
        SampleSizeBox stsz = (SampleSizeBox)Path.getPath((AbstractContainerBox)stbl, (String)"stsz[0]");
        TimeToSampleBox stts = (TimeToSampleBox)Path.getPath((AbstractContainerBox)stbl, (String)"stts[0]");
        SyncSampleBox stss = (SyncSampleBox)Path.getPath((AbstractContainerBox)stbl, (String)"stss[0]");
        CompositionTimeToSample ctts = (CompositionTimeToSample)Path.getPath((AbstractContainerBox)stbl, (String)"ctts[0]");
        if (streamingTrack.getTrackExtension(CompositionTimeTrackExtension.class) != null && ctts == null) {
            ctts = new CompositionTimeToSample();
            ctts.setEntries(new ArrayList());
            ArrayList<CompositionTimeToSample> bs = new ArrayList<CompositionTimeToSample>(stbl.getBoxes());
            bs.add(bs.indexOf(stts), ctts);
        }
        long[] sampleSizes = new long[samples.size()];
        int i = 0;
        for (StreamingSample sample : samples) {
            sampleSizes[i++] = sample.getContent().limit();
            if (ctts != null) {
                ctts.getEntries().add(new CompositionTimeToSample.Entry(1, CastUtils.l2i((long)sample.getSampleExtension(CompositionTimeSampleExtension.class).getCompositionTimeOffset())));
            }
            assert (stts != null);
            if (stts.getEntries().isEmpty()) {
                ArrayList<TimeToSampleBox.Entry> entries = new ArrayList<TimeToSampleBox.Entry>(stts.getEntries());
                entries.add(new TimeToSampleBox.Entry(1L, sample.getDuration()));
                stts.setEntries(entries);
            } else {
                TimeToSampleBox.Entry sttsEntry = (TimeToSampleBox.Entry)stts.getEntries().get(stts.getEntries().size() - 1);
                if (sttsEntry.getDelta() == sample.getDuration()) {
                    sttsEntry.setCount(sttsEntry.getCount() + 1L);
                } else {
                    stts.getEntries().add(new TimeToSampleBox.Entry(1L, sample.getDuration()));
                }
            }
            SampleFlagsSampleExtension sampleFlagsSampleExtension = sample.getSampleExtension(SampleFlagsSampleExtension.class);
            if (sampleFlagsSampleExtension != null && sampleFlagsSampleExtension.isSyncSample()) {
                if (stss == null) {
                    stss = new SyncSampleBox();
                    stbl.addBox((Box)stss);
                }
                stss.setSampleNumber(Mp4Arrays.copyOfAndAppend((long[])stss.getSampleNumber(), (long[])new long[]{sampleNumber}));
            }
            ++sampleNumber;
        }
        assert (stsz != null);
        stsz.setSampleSizes(Mp4Arrays.copyOfAndAppend((long[])stsz.getSampleSizes(), (long[])sampleSizes));
        this.sampleNumbers.put(streamingTrack, sampleNumber);
        samples.clear();
        LOG.debug("CC created. mdat size: " + cc.mdat.size);
        return cc;
    }

    @Override
    protected Box createMdhd(StreamingTrack streamingTrack) {
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(this.creationTime);
        mdhd.setModificationTime(this.creationTime);
        mdhd.setDuration(this.nextSampleStartTime.get(streamingTrack).longValue());
        mdhd.setTimescale(streamingTrack.getTimescale());
        mdhd.setLanguage(streamingTrack.getLanguage());
        return mdhd;
    }

    private class ChunkContainer {
        Mdat mdat;
        StreamingTrack streamingTrack;
        long duration;

        private ChunkContainer() {
        }
    }

    private class Mdat
    implements Box {
        ArrayList<StreamingSample> samples;
        long size;

        public Mdat(List<StreamingSample> samples) {
            this.samples = new ArrayList<StreamingSample>(samples);
            this.size = 8L;
            for (StreamingSample sample : samples) {
                this.size += (long)sample.getContent().limit();
            }
        }

        public String getType() {
            return "mdat";
        }

        public long getSize() {
            return this.size;
        }

        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            writableByteChannel.write(ByteBuffer.wrap(new byte[]{(byte)((this.size & 0xFFFFFFFFFF000000L) >> 24), (byte)((this.size & 0xFF0000L) >> 16), (byte)((this.size & 0xFF00L) >> 8), (byte)(this.size & 0xFFL), 109, 100, 97, 116}));
            for (StreamingSample sample : this.samples) {
                writableByteChannel.write(sample.getContent().rewind());
            }
        }
    }
}

