/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264.spspps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.mp4parser.streaming.input.h264.spspps.ByteBufferBitreader;
import org.mp4parser.streaming.input.h264.spspps.ScalingList;
import org.mp4parser.streaming.input.h264.spspps.ScalingMatrix;

public class PictureParameterSet {
    public boolean entropy_coding_mode_flag;
    public int num_ref_idx_l0_active_minus1;
    public int num_ref_idx_l1_active_minus1;
    public int slice_group_change_rate_minus1;
    public int pic_parameter_set_id;
    public int seq_parameter_set_id;
    public boolean bottom_field_pic_order_in_frame_present_flag;
    public int num_slice_groups_minus1;
    public int slice_group_map_type;
    public boolean weighted_pred_flag;
    public int weighted_bipred_idc;
    public int pic_init_qp_minus26;
    public int pic_init_qs_minus26;
    public int chroma_qp_index_offset;
    public boolean deblocking_filter_control_present_flag;
    public boolean constrained_intra_pred_flag;
    public boolean redundant_pic_cnt_present_flag;
    public int[] top_left;
    public int[] bottom_right;
    public int[] run_length_minus1;
    public boolean slice_group_change_direction_flag;
    public int[] slice_group_id;
    public PPSExt extended;

    public static PictureParameterSet read(ByteBuffer bb) throws IOException {
        ByteBufferBitreader reader = new ByteBufferBitreader(bb);
        PictureParameterSet pps = new PictureParameterSet();
        pps.pic_parameter_set_id = reader.readUE();
        pps.seq_parameter_set_id = reader.readUE();
        pps.entropy_coding_mode_flag = reader.readBool();
        pps.bottom_field_pic_order_in_frame_present_flag = reader.readBool();
        pps.num_slice_groups_minus1 = reader.readUE();
        if (pps.num_slice_groups_minus1 > 0) {
            int iGroup;
            pps.slice_group_map_type = reader.readUE();
            pps.top_left = new int[pps.num_slice_groups_minus1 + 1];
            pps.bottom_right = new int[pps.num_slice_groups_minus1 + 1];
            pps.run_length_minus1 = new int[pps.num_slice_groups_minus1 + 1];
            if (pps.slice_group_map_type == 0) {
                for (iGroup = 0; iGroup <= pps.num_slice_groups_minus1; ++iGroup) {
                    pps.run_length_minus1[iGroup] = reader.readUE();
                }
            } else if (pps.slice_group_map_type == 2) {
                for (iGroup = 0; iGroup < pps.num_slice_groups_minus1; ++iGroup) {
                    pps.top_left[iGroup] = reader.readUE();
                    pps.bottom_right[iGroup] = reader.readUE();
                }
            } else if (pps.slice_group_map_type == 3 || pps.slice_group_map_type == 4 || pps.slice_group_map_type == 5) {
                pps.slice_group_change_direction_flag = reader.readBool();
                pps.slice_group_change_rate_minus1 = reader.readUE();
            } else if (pps.slice_group_map_type == 6) {
                int NumberBitsPerSliceGroupId = pps.num_slice_groups_minus1 + 1 > 4 ? 3 : (pps.num_slice_groups_minus1 + 1 > 2 ? 2 : 1);
                int pic_size_in_map_units_minus1 = reader.readUE();
                pps.slice_group_id = new int[pic_size_in_map_units_minus1 + 1];
                for (int i = 0; i <= pic_size_in_map_units_minus1; ++i) {
                    pps.slice_group_id[i] = (int)reader.readNBit(NumberBitsPerSliceGroupId);
                }
            }
        }
        pps.num_ref_idx_l0_active_minus1 = reader.readUE();
        pps.num_ref_idx_l1_active_minus1 = reader.readUE();
        pps.weighted_pred_flag = reader.readBool();
        pps.weighted_bipred_idc = (int)reader.readNBit(2);
        pps.pic_init_qp_minus26 = reader.readSE();
        pps.pic_init_qs_minus26 = reader.readSE();
        pps.chroma_qp_index_offset = reader.readSE();
        pps.deblocking_filter_control_present_flag = reader.readBool();
        pps.constrained_intra_pred_flag = reader.readBool();
        pps.redundant_pic_cnt_present_flag = reader.readBool();
        if (reader.moreRBSPData()) {
            pps.extended = new PPSExt();
            pps.extended.transform_8x8_mode_flag = reader.readBool();
            boolean pic_scaling_matrix_present_flag = reader.readBool();
            if (pic_scaling_matrix_present_flag) {
                for (int i = 0; i < 6 + 2 * (pps.extended.transform_8x8_mode_flag ? 1 : 0); ++i) {
                    boolean pic_scaling_list_present_flag = reader.readBool();
                    if (!pic_scaling_list_present_flag) continue;
                    pps.extended.scalindMatrix.ScalingList4x4 = new ScalingList[8];
                    pps.extended.scalindMatrix.ScalingList8x8 = new ScalingList[8];
                    if (i < 6) {
                        pps.extended.scalindMatrix.ScalingList4x4[i] = ScalingList.read(reader, 16);
                        continue;
                    }
                    pps.extended.scalindMatrix.ScalingList8x8[i - 6] = ScalingList.read(reader, 64);
                }
            }
            pps.extended.second_chroma_qp_index_offset = reader.readSE();
        }
        return pps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bottom_right);
        result = 31 * result + this.chroma_qp_index_offset;
        result = 31 * result + (this.constrained_intra_pred_flag ? 1231 : 1237);
        result = 31 * result + (this.deblocking_filter_control_present_flag ? 1231 : 1237);
        result = 31 * result + (this.entropy_coding_mode_flag ? 1231 : 1237);
        result = 31 * result + (this.extended == null ? 0 : this.extended.hashCode());
        result = 31 * result + this.num_ref_idx_l0_active_minus1;
        result = 31 * result + this.num_ref_idx_l1_active_minus1;
        result = 31 * result + this.num_slice_groups_minus1;
        result = 31 * result + this.pic_init_qp_minus26;
        result = 31 * result + this.pic_init_qs_minus26;
        result = 31 * result + (this.bottom_field_pic_order_in_frame_present_flag ? 1231 : 1237);
        result = 31 * result + this.pic_parameter_set_id;
        result = 31 * result + (this.redundant_pic_cnt_present_flag ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.run_length_minus1);
        result = 31 * result + this.seq_parameter_set_id;
        result = 31 * result + (this.slice_group_change_direction_flag ? 1231 : 1237);
        result = 31 * result + this.slice_group_change_rate_minus1;
        result = 31 * result + Arrays.hashCode(this.slice_group_id);
        result = 31 * result + this.slice_group_map_type;
        result = 31 * result + Arrays.hashCode(this.top_left);
        result = 31 * result + this.weighted_bipred_idc;
        result = 31 * result + (this.weighted_pred_flag ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PictureParameterSet other = (PictureParameterSet)obj;
        if (!Arrays.equals(this.bottom_right, other.bottom_right)) {
            return false;
        }
        if (this.chroma_qp_index_offset != other.chroma_qp_index_offset) {
            return false;
        }
        if (this.constrained_intra_pred_flag != other.constrained_intra_pred_flag) {
            return false;
        }
        if (this.deblocking_filter_control_present_flag != other.deblocking_filter_control_present_flag) {
            return false;
        }
        if (this.entropy_coding_mode_flag != other.entropy_coding_mode_flag) {
            return false;
        }
        if (this.extended == null ? other.extended != null : !this.extended.equals(other.extended)) {
            return false;
        }
        if (this.num_ref_idx_l0_active_minus1 != other.num_ref_idx_l0_active_minus1) {
            return false;
        }
        if (this.num_ref_idx_l1_active_minus1 != other.num_ref_idx_l1_active_minus1) {
            return false;
        }
        if (this.num_slice_groups_minus1 != other.num_slice_groups_minus1) {
            return false;
        }
        if (this.pic_init_qp_minus26 != other.pic_init_qp_minus26) {
            return false;
        }
        if (this.pic_init_qs_minus26 != other.pic_init_qs_minus26) {
            return false;
        }
        if (this.bottom_field_pic_order_in_frame_present_flag != other.bottom_field_pic_order_in_frame_present_flag) {
            return false;
        }
        if (this.pic_parameter_set_id != other.pic_parameter_set_id) {
            return false;
        }
        if (this.redundant_pic_cnt_present_flag != other.redundant_pic_cnt_present_flag) {
            return false;
        }
        if (!Arrays.equals(this.run_length_minus1, other.run_length_minus1)) {
            return false;
        }
        if (this.seq_parameter_set_id != other.seq_parameter_set_id) {
            return false;
        }
        if (this.slice_group_change_direction_flag != other.slice_group_change_direction_flag) {
            return false;
        }
        if (this.slice_group_change_rate_minus1 != other.slice_group_change_rate_minus1) {
            return false;
        }
        if (!Arrays.equals(this.slice_group_id, other.slice_group_id)) {
            return false;
        }
        if (this.slice_group_map_type != other.slice_group_map_type) {
            return false;
        }
        if (!Arrays.equals(this.top_left, other.top_left)) {
            return false;
        }
        if (this.weighted_bipred_idc != other.weighted_bipred_idc) {
            return false;
        }
        return this.weighted_pred_flag == other.weighted_pred_flag;
    }

    public String toString() {
        return "PictureParameterSet{\n       entropy_coding_mode_flag=" + this.entropy_coding_mode_flag + ",\n       num_ref_idx_l0_active_minus1=" + this.num_ref_idx_l0_active_minus1 + ",\n       num_ref_idx_l1_active_minus1=" + this.num_ref_idx_l1_active_minus1 + ",\n       slice_group_change_rate_minus1=" + this.slice_group_change_rate_minus1 + ",\n       pic_parameter_set_id=" + this.pic_parameter_set_id + ",\n       seq_parameter_set_id=" + this.seq_parameter_set_id + ",\n       pic_order_present_flag=" + this.bottom_field_pic_order_in_frame_present_flag + ",\n       num_slice_groups_minus1=" + this.num_slice_groups_minus1 + ",\n       slice_group_map_type=" + this.slice_group_map_type + ",\n       weighted_pred_flag=" + this.weighted_pred_flag + ",\n       weighted_bipred_idc=" + this.weighted_bipred_idc + ",\n       pic_init_qp_minus26=" + this.pic_init_qp_minus26 + ",\n       pic_init_qs_minus26=" + this.pic_init_qs_minus26 + ",\n       chroma_qp_index_offset=" + this.chroma_qp_index_offset + ",\n       deblocking_filter_control_present_flag=" + this.deblocking_filter_control_present_flag + ",\n       constrained_intra_pred_flag=" + this.constrained_intra_pred_flag + ",\n       redundant_pic_cnt_present_flag=" + this.redundant_pic_cnt_present_flag + ",\n       top_left=" + this.top_left + ",\n       bottom_right=" + this.bottom_right + ",\n       run_length_minus1=" + this.run_length_minus1 + ",\n       slice_group_change_direction_flag=" + this.slice_group_change_direction_flag + ",\n       slice_group_id=" + this.slice_group_id + ",\n       extended=" + this.extended + '}';
    }

    public static class PPSExt {
        public boolean transform_8x8_mode_flag;
        public ScalingMatrix scalindMatrix = new ScalingMatrix();
        public int second_chroma_qp_index_offset;
        public boolean[] pic_scaling_list_present_flag;

        public String toString() {
            return "PPSExt{transform_8x8_mode_flag=" + this.transform_8x8_mode_flag + ", scalindMatrix=" + this.scalindMatrix + ", second_chroma_qp_index_offset=" + this.second_chroma_qp_index_offset + ", pic_scaling_list_present_flag=" + this.pic_scaling_list_present_flag + '}';
        }
    }
}

