/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.mp4;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.mp4parser.tools.CastUtils;

public class DiscardingByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected long startOffset = 0L;

    public DiscardingByteArrayOutputStream() {
        this(32);
    }

    public DiscardingByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public byte[] get(long start, int count) {
        byte[] result = new byte[count];
        try {
            System.arraycopy(this.buf, CastUtils.l2i((long)(start - this.startOffset)), result, 0, count);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("start: " + start + " count: " + count + " startOffset:" + this.startOffset + " count:" + count + " len(buf):" + this.buf.length + " (start - startOffset):" + (start - this.startOffset));
            throw e;
        }
        return result;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }

    public synchronized long available() {
        return this.startOffset + (long)this.count;
    }

    public synchronized void discardTo(long n) {
        System.arraycopy(this.buf, CastUtils.l2i((long)(n - this.startOffset)), this.buf, 0, CastUtils.l2i((long)((long)this.buf.length - (n - this.startOffset))));
        this.count = (int)((long)this.count - (n - this.startOffset));
        this.startOffset = n;
    }
}

