/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264.spspps;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferBitreader {
    ByteBuffer buffer;
    int nBit;
    private int currentByte;
    private int nextByte;

    public ByteBufferBitreader(ByteBuffer buffer) {
        this.buffer = buffer;
        this.currentByte = this.get();
        this.nextByte = this.get();
    }

    public int get() {
        try {
            int i = this.buffer.get();
            i = i < 0 ? i + 256 : i;
            return i;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int read1Bit() throws IOException {
        if (this.nBit == 8) {
            this.advance();
            if (this.currentByte == -1) {
                return -1;
            }
        }
        int res = this.currentByte >> 7 - this.nBit & 1;
        ++this.nBit;
        return res;
    }

    private void advance() throws IOException {
        this.currentByte = this.nextByte;
        this.nextByte = this.get();
        this.nBit = 0;
    }

    public int readUE() throws IOException {
        int cnt = 0;
        while (this.read1Bit() == 0) {
            ++cnt;
        }
        int res = 0;
        if (cnt > 0) {
            res = (int)((long)((1 << cnt) - 1) + this.readNBit(cnt));
        }
        return res;
    }

    public long readNBit(int n) throws IOException {
        if (n > 64) {
            throw new IllegalArgumentException("Can not readByte more then 64 bit");
        }
        long val = 0L;
        for (int i = 0; i < n; ++i) {
            val <<= 1;
            val |= (long)this.read1Bit();
        }
        return val;
    }

    public boolean readBool() throws IOException {
        return this.read1Bit() != 0;
    }

    public int readSE() throws IOException {
        int val = this.readUE();
        int sign = ((val & 1) << 1) - 1;
        val = ((val >> 1) + (val & 1)) * sign;
        return val;
    }

    public boolean moreRBSPData() throws IOException {
        int tail;
        int mask;
        if (this.nBit == 8) {
            this.advance();
        }
        boolean hasTail = (this.currentByte & (mask = ((tail = 1 << 8 - this.nBit - 1) << 1) - 1)) == tail;
        return this.currentByte != -1 && (this.nextByte != -1 || !hasTail);
    }
}

