/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264;

import org.mp4parser.streaming.SampleExtension;
import org.mp4parser.streaming.input.h264.spspps.SliceHeader;

class PictureOrderCountType0SampleExtension
implements SampleExtension {
    int picOrderCntMsb;
    int picOrderCountLsb;

    public PictureOrderCountType0SampleExtension(SliceHeader currentSlice, PictureOrderCountType0SampleExtension previous) {
        int prevPicOrderCntLsb = 0;
        int prevPicOrderCntMsb = 0;
        if (previous != null) {
            prevPicOrderCntLsb = previous.picOrderCountLsb;
            prevPicOrderCntMsb = previous.picOrderCntMsb;
        }
        int max_pic_order_count_lsb = 1 << currentSlice.sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
        this.picOrderCountLsb = currentSlice.pic_order_cnt_lsb;
        this.picOrderCntMsb = 0;
        this.picOrderCntMsb = this.picOrderCountLsb < prevPicOrderCntLsb && prevPicOrderCntLsb - this.picOrderCountLsb >= max_pic_order_count_lsb / 2 ? prevPicOrderCntMsb + max_pic_order_count_lsb : (this.picOrderCountLsb > prevPicOrderCntLsb && this.picOrderCountLsb - prevPicOrderCntLsb > max_pic_order_count_lsb / 2 ? prevPicOrderCntMsb - max_pic_order_count_lsb : prevPicOrderCntMsb);
    }

    public int getPoc() {
        return this.picOrderCntMsb + this.picOrderCountLsb;
    }

    public String toString() {
        return "picOrderCntMsb=" + this.picOrderCntMsb + ", picOrderCountLsb=" + this.picOrderCountLsb;
    }
}

