/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.streaming.input.h264;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part15.AvcConfigurationBox;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.streaming.StreamingSample;
import org.mp4parser.streaming.extensions.CompositionTimeSampleExtension;
import org.mp4parser.streaming.extensions.CompositionTimeTrackExtension;
import org.mp4parser.streaming.extensions.DimensionTrackExtension;
import org.mp4parser.streaming.extensions.SampleFlagsSampleExtension;
import org.mp4parser.streaming.input.StreamingSampleImpl;
import org.mp4parser.streaming.input.h264.AbstractH264Track;
import org.mp4parser.streaming.input.h264.H264NalUnitHeader;
import org.mp4parser.streaming.input.h264.PictureOrderCountType0SampleExtension;
import org.mp4parser.streaming.input.h264.spspps.PictureParameterSet;
import org.mp4parser.streaming.input.h264.spspps.SeqParameterSet;
import org.mp4parser.streaming.input.h264.spspps.SliceHeader;

public abstract class H264NalConsumingTrack
extends AbstractH264Track {
    private static final Logger LOG = Logger.getLogger(H264NalConsumingTrack.class.getName());
    int max_dec_frame_buffering = 16;
    List<StreamingSample> decFrameBuffer = new ArrayList<StreamingSample>();
    List<StreamingSample> decFrameBuffer2 = new ArrayList<StreamingSample>();
    LinkedHashMap<Integer, ByteBuffer> spsIdToSpsBytes = new LinkedHashMap();
    LinkedHashMap<Integer, SeqParameterSet> spsIdToSps = new LinkedHashMap();
    LinkedHashMap<Integer, ByteBuffer> ppsIdToPpsBytes = new LinkedHashMap();
    LinkedHashMap<Integer, PictureParameterSet> ppsIdToPps = new LinkedHashMap();
    BlockingQueue<SeqParameterSet> spsForConfig = new LinkedBlockingDeque<SeqParameterSet>();
    int timescale = 0;
    int frametick = 0;
    boolean configured;
    SampleDescriptionBox stsd;
    SeqParameterSet currentSeqParameterSet = null;
    PictureParameterSet currentPictureParameterSet = null;
    List<ByteBuffer> buffered = new ArrayList<ByteBuffer>();
    FirstVclNalDetector fvnd = null;
    H264NalUnitHeader sliceNalUnitHeader;

    public static H264NalUnitHeader getNalUnitHeader(ByteBuffer nal) {
        H264NalUnitHeader nalUnitHeader = new H264NalUnitHeader();
        byte type = nal.get(0);
        nalUnitHeader.nal_ref_idc = type >> 5 & 3;
        nalUnitHeader.nal_unit_type = type & 0x1F;
        return nalUnitHeader;
    }

    protected void consumeNal(ByteBuffer nal) throws IOException {
        H264NalUnitHeader nalUnitHeader = H264NalConsumingTrack.getNalUnitHeader(nal);
        switch (nalUnitHeader.nal_unit_type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                FirstVclNalDetector current = new FirstVclNalDetector(nal, nalUnitHeader.nal_ref_idc, nalUnitHeader.nal_unit_type);
                this.sliceNalUnitHeader = nalUnitHeader;
                if (this.fvnd != null && this.fvnd.isFirstInNew(current)) {
                    LOG.finer("Wrapping up cause of first vcl nal is found");
                    this.pushSample(this.createSample(this.buffered, this.fvnd.sliceHeader, this.sliceNalUnitHeader), false, false);
                    this.buffered.clear();
                }
                this.fvnd = current;
                this.buffered.add(nal);
                break;
            }
            case 6: {
                if (this.fvnd != null) {
                    LOG.finer("Wrapping up cause of SEI after vcl marks new sample");
                    this.pushSample(this.createSample(this.buffered, this.fvnd.sliceHeader, this.sliceNalUnitHeader), false, false);
                    this.buffered.clear();
                    this.fvnd = null;
                }
                this.buffered.add(nal);
                break;
            }
            case 9: {
                if (this.fvnd != null) {
                    LOG.finer("Wrapping up cause of AU after vcl marks new sample");
                    this.pushSample(this.createSample(this.buffered, this.fvnd.sliceHeader, this.sliceNalUnitHeader), false, false);
                    this.buffered.clear();
                    this.fvnd = null;
                }
                this.buffered.add(nal);
                break;
            }
            case 7: {
                if (this.fvnd != null) {
                    LOG.finer("Wrapping up cause of SPS after vcl marks new sample");
                    this.pushSample(this.createSample(this.buffered, this.fvnd.sliceHeader, this.sliceNalUnitHeader), false, false);
                    this.buffered.clear();
                    this.fvnd = null;
                }
                this.handleSPS(nal);
                break;
            }
            case 8: {
                if (this.fvnd != null) {
                    LOG.finer("Wrapping up cause of PPS after vcl marks new sample");
                    this.pushSample(this.createSample(this.buffered, this.fvnd.sliceHeader, this.sliceNalUnitHeader), false, false);
                    this.buffered.clear();
                    this.fvnd = null;
                }
                this.handlePPS(nal);
                break;
            }
            case 10: 
            case 11: {
                return;
            }
            case 13: {
                throw new IOException("Sequence parameter set extension is not yet handled. Needs TLC.");
            }
            default: {
                LOG.warning("Unknown NAL unit type: " + nalUnitHeader.nal_unit_type);
            }
        }
    }

    protected void pushSample(StreamingSample ss, boolean all, boolean force) throws IOException {
        if (ss != null) {
            this.decFrameBuffer.add(ss);
        }
        if (all) {
            while (this.decFrameBuffer.size() > 0) {
                this.pushSample(null, false, true);
            }
        } else if (this.decFrameBuffer.size() - 1 > this.max_dec_frame_buffering || force) {
            StreamingSample first = this.decFrameBuffer.remove(0);
            PictureOrderCountType0SampleExtension poct0se = first.getSampleExtension(PictureOrderCountType0SampleExtension.class);
            if (poct0se == null) {
                this.sampleSink.acceptSample(first, this);
            } else {
                int delay = 0;
                for (StreamingSample streamingSample : this.decFrameBuffer) {
                    if (poct0se.getPoc() <= streamingSample.getSampleExtension(PictureOrderCountType0SampleExtension.class).getPoc()) continue;
                    ++delay;
                }
                for (StreamingSample streamingSample : this.decFrameBuffer2) {
                    if (poct0se.getPoc() >= streamingSample.getSampleExtension(PictureOrderCountType0SampleExtension.class).getPoc()) continue;
                    --delay;
                }
                this.decFrameBuffer2.add(first);
                if (this.decFrameBuffer2.size() > this.max_dec_frame_buffering) {
                    this.decFrameBuffer2.remove(0).removeSampleExtension(PictureOrderCountType0SampleExtension.class);
                }
                first.addSampleExtension(CompositionTimeSampleExtension.create(delay * this.frametick));
                this.sampleSink.acceptSample(first, this);
            }
        }
    }

    protected SampleFlagsSampleExtension createSampleFlagsSampleExtension(H264NalUnitHeader nu, SliceHeader sliceHeader) {
        SampleFlagsSampleExtension sampleFlagsSampleExtension = new SampleFlagsSampleExtension();
        if (nu.nal_ref_idc == 0) {
            sampleFlagsSampleExtension.setSampleIsDependedOn(2);
        } else {
            sampleFlagsSampleExtension.setSampleIsDependedOn(1);
        }
        if (sliceHeader.slice_type == SliceHeader.SliceType.I || sliceHeader.slice_type == SliceHeader.SliceType.SI) {
            sampleFlagsSampleExtension.setSampleDependsOn(2);
        } else {
            sampleFlagsSampleExtension.setSampleDependsOn(1);
        }
        sampleFlagsSampleExtension.setSampleIsNonSyncSample(5 != nu.nal_unit_type);
        return sampleFlagsSampleExtension;
    }

    protected PictureOrderCountType0SampleExtension createPictureOrderCountType0SampleExtension(SliceHeader sliceHeader) {
        if (sliceHeader.sps.pic_order_cnt_type == 0) {
            return new PictureOrderCountType0SampleExtension(sliceHeader, this.decFrameBuffer.size() > 0 ? this.decFrameBuffer.get(this.decFrameBuffer.size() - 1).getSampleExtension(PictureOrderCountType0SampleExtension.class) : null);
        }
        if (sliceHeader.sps.pic_order_cnt_type == 1) {
            throw new RuntimeException("pic_order_cnt_type == 1 needs to be implemented");
        }
        if (sliceHeader.sps.pic_order_cnt_type == 2) {
            return null;
        }
        throw new RuntimeException("I don't know sliceHeader.sps.pic_order_cnt_type of " + sliceHeader.sps.pic_order_cnt_type);
    }

    protected StreamingSample createSample(List<ByteBuffer> nals, SliceHeader sliceHeader, H264NalUnitHeader nu) throws IOException {
        LOG.finer("Create Sample");
        this.configure();
        if (this.timescale == 0 || this.frametick == 0) {
            throw new IOException("Frame Rate needs to be configured either by hand or by SPS before samples can be created");
        }
        StreamingSampleImpl ss = new StreamingSampleImpl(nals, (long)this.frametick);
        ss.addSampleExtension(this.createSampleFlagsSampleExtension(nu, sliceHeader));
        ss.addSampleExtension(this.createPictureOrderCountType0SampleExtension(sliceHeader));
        return ss;
    }

    public void setFrametick(int frametick) {
        this.frametick = frametick;
    }

    public synchronized void configure() {
        if (!this.configured) {
            int _frametick;
            int _timescale;
            SeqParameterSet sps;
            try {
                sps = this.spsForConfig.poll(5L, TimeUnit.SECONDS);
                if (sps == null) {
                    LOG.warning("Can't determine frame rate as no SPS became available in time");
                    return;
                }
            }
            catch (InterruptedException e) {
                LOG.warning(e.getMessage());
                LOG.warning("Can't determine frame rate as no SPS became available in time");
                return;
            }
            if (sps.pic_order_cnt_type == 0 || sps.pic_order_cnt_type == 1) {
                this.addTrackExtension(new CompositionTimeTrackExtension());
            }
            int width = (sps.pic_width_in_mbs_minus1 + 1) * 16;
            int mult = 2;
            if (sps.frame_mbs_only_flag) {
                mult = 1;
            }
            int height = 16 * (sps.pic_height_in_map_units_minus1 + 1) * mult;
            if (sps.frame_cropping_flag) {
                int chromaArrayType = 0;
                if (!sps.residual_color_transform_flag) {
                    chromaArrayType = sps.chroma_format_idc.getId();
                }
                int cropUnitX = 1;
                int cropUnitY = mult;
                if (chromaArrayType != 0) {
                    cropUnitX = sps.chroma_format_idc.getSubWidth();
                    cropUnitY = sps.chroma_format_idc.getSubHeight() * mult;
                }
                width -= cropUnitX * (sps.frame_crop_left_offset + sps.frame_crop_right_offset);
                height -= cropUnitY * (sps.frame_crop_top_offset + sps.frame_crop_bottom_offset);
            }
            VisualSampleEntry visualSampleEntry = new VisualSampleEntry("avc1");
            visualSampleEntry.setDataReferenceIndex(1);
            visualSampleEntry.setDepth(24);
            visualSampleEntry.setFrameCount(1);
            visualSampleEntry.setHorizresolution(72.0);
            visualSampleEntry.setVertresolution(72.0);
            DimensionTrackExtension dte = this.getTrackExtension(DimensionTrackExtension.class);
            if (dte == null) {
                this.addTrackExtension(new DimensionTrackExtension(width, height));
            }
            visualSampleEntry.setWidth(width);
            visualSampleEntry.setHeight(height);
            visualSampleEntry.setCompressorname("AVC Coding");
            AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
            avcConfigurationBox.setSequenceParameterSets(new ArrayList<ByteBuffer>(this.spsIdToSpsBytes.values()));
            avcConfigurationBox.setPictureParameterSets(new ArrayList<ByteBuffer>(this.ppsIdToPpsBytes.values()));
            avcConfigurationBox.setAvcLevelIndication(sps.level_idc);
            avcConfigurationBox.setAvcProfileIndication(sps.profile_idc);
            avcConfigurationBox.setBitDepthLumaMinus8(sps.bit_depth_luma_minus8);
            avcConfigurationBox.setBitDepthChromaMinus8(sps.bit_depth_chroma_minus8);
            avcConfigurationBox.setChromaFormat(sps.chroma_format_idc.getId());
            avcConfigurationBox.setConfigurationVersion(1);
            avcConfigurationBox.setLengthSizeMinusOne(3);
            avcConfigurationBox.setProfileCompatibility((sps.constraint_set_0_flag ? 128 : 0) + (sps.constraint_set_1_flag ? 64 : 0) + (sps.constraint_set_2_flag ? 32 : 0) + (sps.constraint_set_3_flag ? 16 : 0) + (sps.constraint_set_4_flag ? 8 : 0) + (int)(sps.reserved_zero_2bits & 3L));
            visualSampleEntry.addBox((Box)avcConfigurationBox);
            this.stsd = new SampleDescriptionBox();
            this.stsd.addBox((Box)visualSampleEntry);
            if (sps.vuiParams != null) {
                _timescale = sps.vuiParams.time_scale >> 1;
                _frametick = sps.vuiParams.num_units_in_tick;
                if (_timescale == 0 || _frametick == 0) {
                    LOG.warning("vuiParams contain invalid values: time_scale: " + _timescale + " and frame_tick: " + _frametick + ". Setting frame rate to 25fps");
                    _timescale = 0;
                    _frametick = 0;
                }
                if (_frametick > 0) {
                    if (_timescale / _frametick > 100) {
                        LOG.warning("Framerate is " + _timescale / _frametick + ". That is suspicious.");
                    }
                } else {
                    LOG.warning("Frametick is " + _frametick + ". That is suspicious.");
                }
                if (sps.vuiParams.bitstreamRestriction != null) {
                    this.max_dec_frame_buffering = sps.vuiParams.bitstreamRestriction.max_dec_frame_buffering;
                }
            } else {
                LOG.warning("Can't determine frame rate as SPS does not contain vuiParama");
                _timescale = 0;
                _frametick = 0;
            }
            if (this.timescale == 0) {
                this.timescale = _timescale;
            }
            if (this.frametick == 0) {
                this.frametick = _frametick;
            }
            if (sps.pic_order_cnt_type == 0) {
                this.addTrackExtension(new CompositionTimeTrackExtension());
            } else if (sps.pic_order_cnt_type == 1) {
                throw new RuntimeException("Have not yet imlemented pic_order_cnt_type 1");
            }
            this.configured = true;
        }
    }

    @Override
    public long getTimescale() {
        this.configure();
        return this.timescale;
    }

    public void setTimescale(int timescale) {
        this.timescale = timescale;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        this.configure();
        return this.stsd;
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public String getLanguage() {
        return "eng";
    }

    protected void handlePPS(ByteBuffer nal) {
        nal.position(1);
        PictureParameterSet _pictureParameterSet = null;
        try {
            this.currentPictureParameterSet = _pictureParameterSet = PictureParameterSet.read(nal);
            ByteBuffer oldPpsSameId = this.ppsIdToPpsBytes.get(_pictureParameterSet.pic_parameter_set_id);
            if (oldPpsSameId != null && !oldPpsSameId.equals(nal)) {
                throw new RuntimeException("OMG - I got two SPS with same ID but different settings! (AVC3 is the solution)");
            }
            this.ppsIdToPpsBytes.put(_pictureParameterSet.pic_parameter_set_id, nal);
            this.ppsIdToPps.put(_pictureParameterSet.pic_parameter_set_id, _pictureParameterSet);
        }
        catch (IOException e) {
            throw new RuntimeException("That's surprising to get IOException when working on ByteArrayInputStream", e);
        }
    }

    protected void handleSPS(ByteBuffer data) {
        data.position(1);
        try {
            SeqParameterSet _seqParameterSet;
            this.currentSeqParameterSet = _seqParameterSet = SeqParameterSet.read(data);
            ByteBuffer oldSpsSameId = this.spsIdToSpsBytes.get(_seqParameterSet.seq_parameter_set_id);
            if (oldSpsSameId != null && !oldSpsSameId.equals(data)) {
                throw new RuntimeException("OMG - I got two SPS with same ID but different settings!");
            }
            this.spsIdToSpsBytes.put(_seqParameterSet.seq_parameter_set_id, data);
            this.spsIdToSps.put(_seqParameterSet.seq_parameter_set_id, _seqParameterSet);
            this.spsForConfig.add(_seqParameterSet);
        }
        catch (IOException e) {
            throw new RuntimeException("That's surprising to get IOException when working on ByteArrayInputStream", e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    class FirstVclNalDetector {
        public final SliceHeader sliceHeader;
        int frame_num;
        int pic_parameter_set_id;
        boolean field_pic_flag;
        boolean bottom_field_flag;
        int nal_ref_idc;
        int pic_order_cnt_type;
        int delta_pic_order_cnt_bottom;
        int pic_order_cnt_lsb;
        int delta_pic_order_cnt_0;
        int delta_pic_order_cnt_1;
        boolean idrPicFlag;
        int idr_pic_id;

        public FirstVclNalDetector(ByteBuffer nal, int nal_ref_idc, int nal_unit_type) {
            SliceHeader sh;
            this.sliceHeader = sh = new SliceHeader(nal, H264NalConsumingTrack.this.spsIdToSps, H264NalConsumingTrack.this.ppsIdToPps, nal_unit_type == 5);
            this.frame_num = sh.frame_num;
            this.pic_parameter_set_id = sh.pic_parameter_set_id;
            this.field_pic_flag = sh.field_pic_flag;
            this.bottom_field_flag = sh.bottom_field_flag;
            this.nal_ref_idc = nal_ref_idc;
            this.pic_order_cnt_type = H264NalConsumingTrack.this.spsIdToSps.get((Object)Integer.valueOf((int)H264NalConsumingTrack.this.ppsIdToPps.get((Object)Integer.valueOf((int)sh.pic_parameter_set_id)).seq_parameter_set_id)).pic_order_cnt_type;
            this.delta_pic_order_cnt_bottom = sh.delta_pic_order_cnt_bottom;
            this.pic_order_cnt_lsb = sh.pic_order_cnt_lsb;
            this.delta_pic_order_cnt_0 = sh.delta_pic_order_cnt_0;
            this.delta_pic_order_cnt_1 = sh.delta_pic_order_cnt_1;
            this.idr_pic_id = sh.idr_pic_id;
        }

        boolean isFirstInNew(FirstVclNalDetector nu) {
            if (nu.frame_num != this.frame_num) {
                return true;
            }
            if (nu.pic_parameter_set_id != this.pic_parameter_set_id) {
                return true;
            }
            if (nu.field_pic_flag != this.field_pic_flag) {
                return true;
            }
            if (nu.field_pic_flag && nu.bottom_field_flag != this.bottom_field_flag) {
                return true;
            }
            if (nu.nal_ref_idc != this.nal_ref_idc) {
                return true;
            }
            if (nu.pic_order_cnt_type == 0 && this.pic_order_cnt_type == 0) {
                if (nu.pic_order_cnt_lsb != this.pic_order_cnt_lsb) {
                    return true;
                }
                if (nu.delta_pic_order_cnt_bottom != this.delta_pic_order_cnt_bottom) {
                    return true;
                }
            }
            if (nu.pic_order_cnt_type == 1 && this.pic_order_cnt_type == 1) {
                if (nu.delta_pic_order_cnt_0 != this.delta_pic_order_cnt_0) {
                    return true;
                }
                if (nu.delta_pic_order_cnt_1 != this.delta_pic_order_cnt_1) {
                    return true;
                }
            }
            if (nu.idrPicFlag != this.idrPicFlag) {
                return true;
            }
            return nu.idrPicFlag && this.idrPicFlag && nu.idr_pic_id != this.idr_pic_id;
        }
    }
}

