/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BoxParser;
import org.mp4parser.RewindableReadableByteChannel;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;

public class MetaBox
extends AbstractContainerBox {
    public static final String TYPE = "meta";
    private int version;
    private int flags;
    private boolean quickTimeFormat;

    public MetaBox() {
        super(TYPE);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    protected final long parseVersionAndFlags(ByteBuffer content) {
        this.version = IsoTypeReader.readUInt8(content);
        this.flags = IsoTypeReader.readUInt24(content);
        return 4L;
    }

    protected final void writeVersionAndFlags(ByteBuffer bb) {
        IsoTypeWriter.writeUInt8(bb, this.version);
        IsoTypeWriter.writeUInt24(bb, this.flags);
    }

    @Override
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        RewindableReadableByteChannel rewindableDataSource = new RewindableReadableByteChannel(dataSource, 20);
        ByteBuffer bb = ByteBuffer.allocate(20);
        int bytesRead = rewindableDataSource.read(bb);
        if (bytesRead == 20) {
            bb.position(4);
            String second4cc = IsoTypeReader.read4cc(bb);
            bb.position(16);
            String fifth4cc = IsoTypeReader.read4cc(bb);
            if ("hdlr".equals(second4cc) && "mdta".equals(fifth4cc)) {
                this.quickTimeFormat = true;
            }
        }
        rewindableDataSource.rewind();
        if (!this.quickTimeFormat) {
            bb = ByteBuffer.allocate(4);
            rewindableDataSource.read(bb);
            this.parseVersionAndFlags(bb.rewind());
        }
        int bytesUsed = this.quickTimeFormat ? 0 : 4;
        this.initContainer(rewindableDataSource, contentSize - (long)bytesUsed, boxParser);
    }

    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write(this.getHeader());
        if (!this.quickTimeFormat) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            this.writeVersionAndFlags(bb);
            writableByteChannel.write(bb.rewind());
        }
        this.writeContainer(writableByteChannel);
    }

    @Override
    public long getSize() {
        long s = this.getContainerSize();
        long t = this.quickTimeFormat ? 0 : 4;
        return s + t + (long)(this.largeBox || s + t >= 0x100000000L ? 16 : 8);
    }
}

