/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.rhttp.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.mortbay.jetty.rhttp.client.ClientListener;
import org.mortbay.jetty.rhttp.client.RHTTPClient;
import org.mortbay.jetty.rhttp.client.RHTTPListener;
import org.mortbay.jetty.rhttp.client.RHTTPRequest;
import org.mortbay.jetty.rhttp.client.RHTTPResponse;

public abstract class AbstractClient
extends AbstractLifeCycle
implements RHTTPClient {
    private final Logger logger = Log.getLogger((String)"org.mortbay.jetty.rhttp.client");
    private final List<RHTTPListener> listeners = new CopyOnWriteArrayList<RHTTPListener>();
    private final List<ClientListener> clientListeners = new CopyOnWriteArrayList<ClientListener>();
    private final String targetId;
    private volatile Status status = Status.DISCONNECTED;

    public AbstractClient(String targetId) {
        this.targetId = targetId;
    }

    @Override
    public String getGatewayURI() {
        return "http://" + this.getHost() + ":" + this.getPort() + this.getPath();
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void addListener(RHTTPListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RHTTPListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addClientListener(ClientListener listener) {
        this.clientListeners.add(listener);
    }

    @Override
    public void removeClientListener(ClientListener listener) {
        this.clientListeners.remove(listener);
    }

    protected void notifyRequests(List<RHTTPRequest> requests) {
        for (RHTTPRequest request : requests) {
            for (RHTTPListener listener : this.listeners) {
                try {
                    listener.onRequest(request);
                }
                catch (Throwable x) {
                    this.logger.warn("Listener " + listener + " threw", x);
                    try {
                        this.deliver(this.newExceptionResponse(request.getId(), x));
                    }
                    catch (IOException xx) {
                        this.logger.debug("Could not deliver exception response", (Throwable)xx);
                    }
                }
            }
        }
    }

    protected RHTTPResponse newExceptionResponse(int requestId, Throwable x) {
        try {
            int statusCode = 500;
            String statusMessage = "Internal Server Error";
            HashMap<String, String> headers = new HashMap<String, String>();
            byte[] body = x.toString().getBytes("UTF-8");
            return new RHTTPResponse(requestId, statusCode, statusMessage, headers, body);
        }
        catch (UnsupportedEncodingException xx) {
            throw new AssertionError((Object)xx);
        }
    }

    protected void notifyConnectRequired() {
        for (ClientListener listener : this.clientListeners) {
            try {
                listener.connectRequired();
            }
            catch (Throwable x) {
                this.logger.warn("ClientListener " + listener + " threw", x);
            }
        }
    }

    protected void notifyConnectException() {
        for (ClientListener listener : this.clientListeners) {
            try {
                listener.connectException();
            }
            catch (Throwable x) {
                this.logger.warn("ClientListener " + listener + " threw", x);
            }
        }
    }

    protected void notifyConnectClosed() {
        for (ClientListener listener : this.clientListeners) {
            try {
                listener.connectClosed();
            }
            catch (Throwable xx) {
                this.logger.warn("ClientListener " + listener + " threw", xx);
            }
        }
    }

    protected void notifyDeliverException(RHTTPResponse response) {
        for (ClientListener listener : this.clientListeners) {
            try {
                listener.deliverException(response);
            }
            catch (Throwable x) {
                this.logger.warn("ClientListener " + listener + " threw", x);
            }
        }
    }

    protected String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            this.getLogger().debug("", (Throwable)x);
            return null;
        }
    }

    protected boolean isConnected() {
        return this.status == Status.CONNECTED;
    }

    protected boolean isDisconnecting() {
        return this.status == Status.DISCONNECTING;
    }

    protected boolean isDisconnected() {
        return this.status == Status.DISCONNECTED;
    }

    @Override
    public void connect() throws IOException {
        if (this.isDisconnected()) {
            this.status = Status.CONNECTING;
        }
        this.syncHandshake();
        this.status = Status.CONNECTED;
        this.asyncConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        if (this.isConnected()) {
            this.status = Status.DISCONNECTING;
            try {
                this.syncDisconnect();
            }
            finally {
                this.status = Status.DISCONNECTED;
            }
        }
    }

    @Override
    public void deliver(RHTTPResponse response) throws IOException {
        this.asyncDeliver(response);
    }

    protected abstract void syncHandshake() throws IOException;

    protected abstract void asyncConnect();

    protected abstract void syncDisconnect() throws IOException;

    protected abstract void asyncDeliver(RHTTPResponse var1);

    protected void connectComplete(byte[] responseContent) throws IOException {
        List<RHTTPRequest> requests = RHTTPRequest.fromFrameBytes(responseContent);
        this.getLogger().debug("Client {} connect returned from gateway, requests {}", new Object[]{this.getTargetId(), requests});
        if (!this.isDisconnecting() && !this.isDisconnected()) {
            this.asyncConnect();
        }
        this.notifyRequests(requests);
    }

    protected static enum Status {
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

