/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

class DistinctIterableImpl<T>
implements DistinctIterable<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final String fieldName;
    private Object filter;
    private long maxTimeMS;

    DistinctIterableImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, String fieldName) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.clazz = (Class)Assertions.notNull((String)"clazz", clazz);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.fieldName = (String)Assertions.notNull((String)"mapFunction", (Object)fieldName);
    }

    @Override
    public DistinctIterable<T> filter(Object filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DistinctIterable<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctIterable<T> batchSize(int batchSize) {
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        DistinctOperation operation = new DistinctOperation(this.namespace, this.fieldName, (Decoder)this.codecRegistry.get(this.clazz)).filter(BsonDocumentWrapper.asBsonDocument((Object)this.filter, (CodecRegistry)this.codecRegistry)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        return new OperationIterable(operation, this.readPreference, this.executor);
    }
}

