/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClients;
import com.mongodb.client.internal.CollectionInfoRetriever;
import com.mongodb.client.internal.CommandMarker;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.KeyManagementService;
import com.mongodb.client.internal.KeyRetriever;
import com.mongodb.client.internal.SimpleMongoClient;
import com.mongodb.client.internal.SimpleMongoClients;
import com.mongodb.crypt.capi.MongoAwsKmsProviderOptions;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoCrypts;
import com.mongodb.crypt.capi.MongoLocalKmsProviderOptions;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.bson.BsonDocument;

public final class Crypts {
    public static Crypt createCrypt(SimpleMongoClient client, AutoEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)Crypts.createMongoCryptOptions(options.getKmsProviders(), options.getSchemaMap())), new CollectionInfoRetriever(client), new CommandMarker(options.getExtraOptions()), Crypts.createKeyRetriever(client, options.getKeyVaultMongoClientSettings(), options.getKeyVaultNamespace()), Crypts.createtKeyManagementService(), options.isBypassAutoEncryption());
    }

    static Crypt create(SimpleMongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)Crypts.createMongoCryptOptions(options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, false, options.getKeyVaultNamespace()), Crypts.createtKeyManagementService());
    }

    private static MongoCryptOptions createMongoCryptOptions(Map<String, Map<String, Object>> kmsProviders, Map<String, BsonDocument> namespaceToLocalSchemaDocumentMap) {
        MongoCryptOptions.Builder mongoCryptOptionsBuilder = MongoCryptOptions.builder();
        for (Map.Entry<String, Map<String, Object>> entry : kmsProviders.entrySet()) {
            if (entry.getKey().equals("aws")) {
                mongoCryptOptionsBuilder.awsKmsProviderOptions(MongoAwsKmsProviderOptions.builder().accessKeyId((String)entry.getValue().get("accessKeyId")).secretAccessKey((String)entry.getValue().get("secretAccessKey")).build());
                continue;
            }
            if (entry.getKey().equals("local")) {
                mongoCryptOptionsBuilder.localKmsProviderOptions(MongoLocalKmsProviderOptions.builder().localMasterKey(ByteBuffer.wrap((byte[])entry.getValue().get("key"))).build());
                continue;
            }
            throw new MongoClientException("Unrecognized KMS provider key: " + entry.getKey());
        }
        mongoCryptOptionsBuilder.localSchemaMap(namespaceToLocalSchemaDocumentMap);
        return mongoCryptOptionsBuilder.build();
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient defaultKeyVaultClient, MongoClientSettings keyVaultMongoClientSettings, String keyVaultNamespaceString) {
        boolean keyRetrieverOwnsClient;
        SimpleMongoClient keyVaultClient;
        if (keyVaultMongoClientSettings != null) {
            keyVaultClient = SimpleMongoClients.create(MongoClients.create(keyVaultMongoClientSettings));
            keyRetrieverOwnsClient = true;
        } else {
            keyVaultClient = defaultKeyVaultClient;
            keyRetrieverOwnsClient = false;
        }
        return Crypts.createKeyRetriever(keyVaultClient, keyRetrieverOwnsClient, keyVaultNamespaceString);
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient keyVaultClient, boolean keyRetrieverOwnsClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, keyRetrieverOwnsClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createtKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", (Throwable)e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

