/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoDriverInformation;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.NettyMongoClients;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactory;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(settings, mongoDriverInformation, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation, connectionString.getStreamType());
    }

    private static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, @Nullable String requestedStreamType) {
        String streamType = MongoClients.getStreamType(requestedStreamType);
        if (MongoClients.isNetty(streamType) && settings.getStreamFactoryFactory() == null) {
            return NettyMongoClients.create(settings, mongoDriverInformation);
        }
        StreamFactory streamFactory = MongoClients.getStreamFactory(settings.getStreamFactoryFactory(), settings.getSocketSettings(), settings.getSslSettings(), streamType);
        StreamFactory heartbeatStreamFactory = MongoClients.getStreamFactory(settings.getStreamFactoryFactory(), settings.getHeartbeatSocketSettings(), settings.getSslSettings(), streamType);
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, null);
    }

    static MongoClient createMongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable Closeable externalResourceCloser) {
        return new MongoClientImpl(settings, new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList()), externalResourceCloser);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return com.mongodb.MongoClientSettings.getDefaultCodecRegistry();
    }

    private static StreamFactory getStreamFactory(@Nullable StreamFactoryFactory streamFactoryFactory, SocketSettings socketSettings, SslSettings sslSettings, String streamType) {
        if (streamFactoryFactory != null) {
            return streamFactoryFactory.create(socketSettings, sslSettings);
        }
        if (MongoClients.isNio2(streamType)) {
            return new AsynchronousSocketChannelStreamFactory(socketSettings, sslSettings);
        }
        throw new IllegalArgumentException("Unsupported stream type: " + streamType);
    }

    private static boolean isNetty(String streamType) {
        return streamType.toLowerCase().equals("netty");
    }

    private static boolean isNio2(String streamType) {
        return streamType.toLowerCase().equals("nio2");
    }

    private static String getStreamType(@Nullable String requestedStreamType) {
        if (requestedStreamType != null) {
            return requestedStreamType;
        }
        return System.getProperty("org.mongodb.async.type", "nio2");
    }

    private MongoClients() {
    }
}

