/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.ListDatabasesIterableImpl;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientOptions;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoDatabaseImpl;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.connection.Cluster;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import java.util.Arrays;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.configuration.RootCodecRegistry;

class MongoClientImpl
implements MongoClient {
    private final Cluster cluster;
    private final MongoClientOptions options;
    private final AsyncOperationExecutor executor;
    private static final RootCodecRegistry DEFAULT_CODEC_REGISTRY = new RootCodecRegistry(Arrays.asList(new ValueCodecProvider(), new DocumentCodecProvider(), new BsonValueCodecProvider()));

    public static RootCodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    MongoClientImpl(MongoClientOptions options, Cluster cluster) {
        this(options, cluster, MongoClientImpl.createOperationExecutor(options, cluster));
    }

    MongoClientImpl(MongoClientOptions options, Cluster cluster, AsyncOperationExecutor executor) {
        this.options = (MongoClientOptions)Assertions.notNull((String)"options", (Object)options);
        this.cluster = (Cluster)Assertions.notNull((String)"cluster", (Object)cluster);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(name, this.options.getCodecRegistry(), this.options.getReadPreference(), this.options.getWriteConcern(), this.executor);
    }

    @Override
    public void close() {
        this.cluster.close();
    }

    @Override
    public MongoClientOptions getOptions() {
        return this.options;
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.listDatabases().map(new Function<Document, String>(){

            public String apply(Document document) {
                return document.getString((Object)"name");
            }
        });
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clazz, (CodecRegistry)DEFAULT_CODEC_REGISTRY, ReadPreference.primary(), this.executor);
    }

    Cluster getCluster() {
        return this.cluster;
    }

    private static AsyncOperationExecutor createOperationExecutor(final MongoClientOptions options, final Cluster cluster) {
        return new AsyncOperationExecutor(){

            public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, SingleResultCallback<T> callback) {
                final SingleResultCallback wrappedCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback);
                AsyncReadWriteBinding binding = MongoClientImpl.getReadWriteBinding(readPreference, options, cluster);
                operation.executeAsync((AsyncReadBinding)binding, new SingleResultCallback<T>((AsyncReadBinding)binding){
                    final /* synthetic */ AsyncReadBinding val$binding;
                    {
                        this.val$binding = asyncReadBinding;
                    }

                    public void onResult(T result, Throwable t) {
                        try {
                            wrappedCallback.onResult(result, t);
                        }
                        finally {
                            this.val$binding.release();
                        }
                    }
                });
            }

            public <T> void execute(AsyncWriteOperation<T> operation, final SingleResultCallback<T> callback) {
                AsyncReadWriteBinding binding = MongoClientImpl.getReadWriteBinding(ReadPreference.primary(), options, cluster);
                operation.executeAsync((AsyncWriteBinding)binding, new SingleResultCallback<T>((AsyncWriteBinding)binding){
                    final /* synthetic */ AsyncWriteBinding val$binding;
                    {
                        this.val$binding = asyncWriteBinding;
                    }

                    public void onResult(T result, Throwable t) {
                        try {
                            ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)callback).onResult(result, t);
                        }
                        finally {
                            this.val$binding.release();
                        }
                    }
                });
            }
        };
    }

    private static AsyncReadWriteBinding getReadWriteBinding(ReadPreference readPreference, MongoClientOptions options, Cluster cluster) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        return new AsyncClusterBinding(cluster, readPreference);
    }
}

