/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListCollectionsFluent;
import com.mongodb.async.client.ListCollectionsFluentImpl;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoCollectionImpl;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CommandWriteOperation;
import com.mongodb.operation.CreateCollectionOperation;
import com.mongodb.operation.DropDatabaseOperation;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;

class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final AsyncOperationExecutor executor;

    MongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, AsyncOperationExecutor executor) {
        this.name = (String)Assertions.notNull((String)"name", (Object)name);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.executor);
    }

    @Override
    public MongoIterable<String> listCollectionNames() {
        return this.listCollections().map(new Function<Document, String>(){

            public String apply(Document result) {
                return (String)result.get((Object)"name");
            }
        });
    }

    @Override
    public ListCollectionsFluent<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <C> ListCollectionsFluent<C> listCollections(Class<C> clazz) {
        return new ListCollectionsFluentImpl<C>(this.name, clazz, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <T> MongoCollection<T> getCollection(String collectionName, Class<T> clazz) {
        return new MongoCollectionImpl<T>(new MongoNamespace(this.name, collectionName), clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public void executeCommand(Object command, SingleResultCallback<Document> callback) {
        this.executeCommand(command, Document.class, callback);
    }

    @Override
    public void executeCommand(Object command, ReadPreference readPreference, SingleResultCallback<Document> callback) {
        this.executeCommand(command, readPreference, Document.class, callback);
    }

    @Override
    public <T> void executeCommand(Object command, Class<T> clazz, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"command", (Object)command);
        this.executor.execute((AsyncWriteOperation)new CommandWriteOperation(this.getName(), this.asBson(command), (Decoder)this.codecRegistry.get(clazz)), callback);
    }

    @Override
    public <T> void executeCommand(Object command, ReadPreference readPreference, Class<T> clazz, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"command", (Object)command);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.executor.execute((AsyncReadOperation)new CommandReadOperation(this.getName(), this.asBson(command), (Decoder)this.codecRegistry.get(clazz)), readPreference, callback);
    }

    @Override
    public void dropDatabase(SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new DropDatabaseOperation(this.name), callback);
    }

    @Override
    public void createCollection(String collectionName, SingleResultCallback<Void> callback) {
        this.createCollection(collectionName, new CreateCollectionOptions(), callback);
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, SingleResultCallback<Void> callback) {
        this.executor.execute((AsyncWriteOperation)new CreateCollectionOperation(this.name, collectionName).capped(createCollectionOptions.isCapped()).sizeInBytes(createCollectionOptions.getSizeInBytes()).autoIndex(createCollectionOptions.isAutoIndex()).maxDocuments(createCollectionOptions.getMaxDocuments()).usePowerOf2Sizes(createCollectionOptions.isUsePowerOf2Sizes()).storageEngineOptions(this.asBson(createCollectionOptions.getStorageEngineOptions())), callback);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument((Object)document, (CodecRegistry)this.codecRegistry);
    }
}

