/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.internal.crypt.capi.CAPI;
import com.mongodb.internal.crypt.capi.CAPIHelper;
import com.sun.jna.Pointer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

class SigningRSAESPKCSCallback
implements CAPI.mongocrypt_hmac_fn {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGN_ALGORITHM = "SHA256withRSA";

    SigningRSAESPKCSCallback() {
    }

    @Override
    public boolean hmac(Pointer ctx, CAPI.mongocrypt_binary_t key, CAPI.mongocrypt_binary_t in, CAPI.mongocrypt_binary_t out, CAPI.mongocrypt_status_t status) {
        try {
            byte[] result = SigningRSAESPKCSCallback.getSignature(CAPIHelper.toByteArray(key), CAPIHelper.toByteArray(in));
            CAPIHelper.writeByteArrayToBinary(out, result);
            return true;
        }
        catch (Exception e) {
            CAPI.mongocrypt_status_set(status, 1, 0, new CAPI.cstring(e.toString()), -1);
            return false;
        }
    }

    static byte[] getSignature(byte[] privateKeyBytes, byte[] dataToSign) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Signature privateSignature = Signature.getInstance(SIGN_ALGORITHM);
        privateSignature.initSign(privateKey);
        privateSignature.update(dataToSign);
        return privateSignature.sign();
    }
}

