/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.internal.crypt.capi.BinaryHolder;
import com.mongodb.internal.crypt.capi.CAPI;
import com.mongodb.internal.crypt.capi.DisposableMemory;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

final class CAPIHelper {
    private static final CodecRegistry CODEC_REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});

    static BinaryHolder toBinary(BsonDocument document) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);
        CODEC_REGISTRY.get(document.getClass()).encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        DisposableMemory memory = new DisposableMemory(buffer.size());
        memory.write(0L, buffer.getInternalBuffer(), 0, buffer.size());
        return new BinaryHolder(memory, CAPI.mongocrypt_binary_new_from_data((Pointer)memory, buffer.getSize()));
    }

    static RawBsonDocument toDocument(CAPI.mongocrypt_binary_t binary) {
        ByteBuffer byteBuffer = CAPIHelper.toByteBuffer(binary);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return new RawBsonDocument(bytes);
    }

    static BinaryHolder toBinary(ByteBuffer buffer) {
        byte[] message = new byte[buffer.remaining()];
        buffer.get(message, 0, buffer.remaining());
        DisposableMemory memory = new DisposableMemory(message.length);
        memory.write(0L, message, 0, message.length);
        return new BinaryHolder(memory, CAPI.mongocrypt_binary_new_from_data((Pointer)memory, message.length));
    }

    static ByteBuffer toByteBuffer(CAPI.mongocrypt_binary_t binary) {
        Pointer pointer = binary.data();
        int length = binary.len();
        return pointer.getByteBuffer(0L, (long)length);
    }

    static byte[] toByteArray(CAPI.mongocrypt_binary_t binary) {
        ByteBuffer byteBuffer = CAPIHelper.toByteBuffer(binary);
        byte[] byteArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    static void writeByteArrayToBinary(CAPI.mongocrypt_binary_t binary, byte[] bytes) {
        if (binary.len() < bytes.length) {
            throw new IllegalArgumentException(String.format("mongocrypt binary of length %d is not large enough to hold %d bytes", binary.len(), bytes.length));
        }
        Pointer outPointer = binary.data();
        outPointer.write(0L, bytes, 0, bytes.length);
    }

    private CAPIHelper() {
    }
}

