/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.sun.jna.Pointer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class CipherCallback
implements CAPI.mongocrypt_crypto_fn {
    private final String algorithm;
    private final String transformation;
    private final int mode;

    CipherCallback(String algorithm, String transformation, int mode) {
        this.algorithm = algorithm;
        this.transformation = transformation;
        this.mode = mode;
    }

    @Override
    public boolean crypt(Pointer ctx, CAPI.mongocrypt_binary_t key, CAPI.mongocrypt_binary_t iv, CAPI.mongocrypt_binary_t in, CAPI.mongocrypt_binary_t out, Pointer bytesWritten, CAPI.mongocrypt_status_t status) {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(CAPIHelper.toByteArray(iv));
            SecretKeySpec secretKeySpec = new SecretKeySpec(CAPIHelper.toByteArray(key), this.algorithm);
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(this.mode, (Key)secretKeySpec, ivParameterSpec);
            byte[] result = cipher.doFinal(CAPIHelper.toByteArray(in));
            CAPIHelper.writeByteArrayToBinary(out, result);
            bytesWritten.setInt(0L, result.length);
            return true;
        }
        catch (Exception e) {
            CAPI.mongocrypt_status_set(status, 1, 0, new CAPI.cstring(e.toString()), -1);
            return false;
        }
    }
}

