/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import org.bson.BsonBinary;

public class MongoExplicitEncryptOptions {
    private final BsonBinary keyId;
    private final String algorithm;

    public static Builder builder() {
        return new Builder();
    }

    public BsonBinary getKeyId() {
        return this.keyId;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private MongoExplicitEncryptOptions(Builder builder) {
        this.keyId = builder.keyId;
        this.algorithm = builder.algorithm;
    }

    public String toString() {
        return "MongoExplicitEncryptOptions{keyId=" + this.keyId + ", algorithm='" + this.algorithm + "'}";
    }

    public static class Builder {
        private BsonBinary keyId;
        private String algorithm;

        private Builder() {
        }

        public Builder keyId(BsonBinary keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public MongoExplicitEncryptOptions build() {
            return new MongoExplicitEncryptOptions(this);
        }
    }
}

