/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.DBObjectCodec;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.DocumentToDBRefTransformer;
import com.mongodb.Function;
import com.mongodb.ListDatabasesIterableImpl;
import com.mongodb.Mongo;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDatabaseImpl;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoDriverInformation;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.session.ClientSession;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class MongoClient
extends Mongo
implements Closeable {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBRefCodecProvider(), new DBObjectCodecProvider(), new DocumentCodecProvider(new DocumentToDBRefTransformer()), new IterableCodecProvider(new DocumentToDBRefTransformer()), new MapCodecProvider(new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new GridFSFileCodecProvider()));

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    public MongoClient() {
        this(new ServerAddress());
    }

    public MongoClient(String host) {
        this(new ServerAddress(host));
    }

    public MongoClient(String host, MongoClientOptions options) {
        this(new ServerAddress(host), options);
    }

    public MongoClient(String host, int port) {
        this(new ServerAddress(host, port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, new MongoClientOptions.Builder().build());
    }

    @Deprecated
    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList) {
        this(addr, credentialsList, MongoClientOptions.builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        super(addr, options);
    }

    @Deprecated
    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(addr, credentialsList, options);
    }

    public MongoClient(ServerAddress addr, MongoCredential credential, MongoClientOptions options) {
        super(addr, Collections.singletonList(credential), options);
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, new MongoClientOptions.Builder().build());
    }

    @Deprecated
    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this(seeds, credentialsList, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, options);
    }

    @Deprecated
    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        super(seeds, credentialsList, options);
    }

    public MongoClient(List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options) {
        super(seeds, Collections.singletonList(credential), options);
    }

    public MongoClient(MongoClientURI uri) {
        super(uri);
    }

    public MongoClient(MongoClientURI uri, MongoDriverInformation mongoDriverInformation) {
        super(uri, mongoDriverInformation);
    }

    @Deprecated
    public MongoClient(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, credentialsList, options, mongoDriverInformation);
    }

    public MongoClient(ServerAddress addr, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(addr, Collections.singletonList(credential), options, mongoDriverInformation);
    }

    @Deprecated
    public MongoClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, credentialsList, options, mongoDriverInformation);
    }

    public MongoClient(List<ServerAddress> seeds, MongoCredential credential, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        super(seeds, Collections.singletonList(credential), options, mongoDriverInformation);
    }

    @Override
    public MongoClientOptions getMongoClientOptions() {
        return super.getMongoClientOptions();
    }

    @Override
    public List<MongoCredential> getCredentialsList() {
        return super.getCredentialsList();
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.executeListDatabaseNames(null);
    }

    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeListDatabaseNames(clientSession);
    }

    private MongoIterable<String> executeListDatabaseNames(ClientSession clientSession) {
        return this.executeListDatabases(clientSession, BsonDocument.class).map(new Function<BsonDocument, String>(){

            @Override
            public String apply(BsonDocument result) {
                return result.getString("name").getValue();
            }
        });
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.executeListDatabases(null, clazz);
    }

    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeListDatabases(clientSession, clazz);
    }

    private <T> ListDatabasesIterable<T> executeListDatabases(ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.getMongoClientOptions().getCodecRegistry(), ReadPreference.primary(), this.createOperationExecutor());
    }

    public MongoDatabase getDatabase(String databaseName) {
        MongoClientOptions clientOptions = this.getMongoClientOptions();
        return new MongoDatabaseImpl(databaseName, clientOptions.getCodecRegistry(), clientOptions.getReadPreference(), clientOptions.getWriteConcern(), clientOptions.getRetryWrites(), clientOptions.getReadConcern(), this.createOperationExecutor());
    }

    public ClientSession startSession(ClientSessionOptions options) {
        ClientSession clientSession = this.createClientSession(options);
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    static DBObjectCodec getCommandCodec() {
        return new DBObjectCodec(MongoClient.getDefaultCodecRegistry());
    }
}

