/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoIterableImpl;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationExecutor;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.binding.ReadBinding;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.MapReduceBatchCursor;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.ReadOperation;
import com.mongodb.session.ClientSession;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonJavaScript;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MapReduceIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements MapReduceIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    MapReduceIterableImpl(ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, String mapFunction, String reduceFunction) {
        super(clientSession, executor, readConcern, readPreference);
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
    }

    @Override
    public void toCollection() {
        if (this.inline) {
            throw new IllegalStateException("The options must specify a non-inline result");
        }
        this.getExecutor().execute(this.createMapReduceToCollectionOperation(), this.getClientSession());
    }

    @Override
    public MapReduceIterable<TResult> collectionName(String collectionName) {
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> scope(Bson scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    ReadPreference getReadPreference() {
        if (this.inline) {
            return super.getReadPreference();
        }
        return ReadPreference.primary();
    }

    @Override
    ReadOperation<BatchCursor<TResult>> asReadOperation() {
        if (this.inline) {
            MapReduceWithInlineResultsOperation<TResult> operation = new MapReduceWithInlineResultsOperation<TResult>(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocument(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocument(this.scope)).sort(this.toBsonDocument(this.sort)).verbose(this.verbose).readConcern(this.getReadConcern()).collation(this.collation);
            if (this.finalizeFunction != null) {
                operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
            }
            return new WrappedMapReduceReadOperation<TResult>(operation);
        }
        this.getExecutor().execute(this.createMapReduceToCollectionOperation(), this.getClientSession());
        String dbName = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        return new FindOperation<TResult>(new MongoNamespace(dbName, this.collectionName), this.codecRegistry.get(this.resultClass)).collation(this.collation).batchSize(this.getBatchSize() == null ? 0 : this.getBatchSize());
    }

    private MapReduceToCollectionOperation createMapReduceToCollectionOperation() {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.collectionName, this.writeConcern).filter(this.toBsonDocument(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocument(this.scope)).sort(this.toBsonDocument(this.sort)).verbose(this.verbose).action(this.action.getValue()).nonAtomic(this.nonAtomic).sharded(this.sharded).databaseName(this.databaseName).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation);
        if (this.finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
        }
        return operation;
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    static class WrappedMapReduceReadOperation<TResult>
    implements ReadOperation<BatchCursor<TResult>> {
        private final ReadOperation<MapReduceBatchCursor<TResult>> operation;

        ReadOperation<MapReduceBatchCursor<TResult>> getOperation() {
            return this.operation;
        }

        WrappedMapReduceReadOperation(MapReduceWithInlineResultsOperation<TResult> operation) {
            this.operation = operation;
        }

        @Override
        public BatchCursor<TResult> execute(ReadBinding binding) {
            return this.operation.execute(binding);
        }
    }
}

