/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bson.BSONException;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;

public class RawBsonDocumentCodec
implements Codec<RawBsonDocument> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(BsonWriter writer, RawBsonDocument value, EncoderContext encoderContext) {
        BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(value.getByteBuffer()), true);
        try {
            writer.pipe(reader);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public RawBsonDocument decode(BsonReader reader, DecoderContext decoderContext) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer, true);
        try {
            writer.pipe(reader);
            BufferExposingByteArrayOutputStream byteArrayOutputStream = new BufferExposingByteArrayOutputStream(writer.getBsonOutput().getSize());
            buffer.pipe(byteArrayOutputStream);
            RawBsonDocument rawBsonDocument = new RawBsonDocument(byteArrayOutputStream.getInternalBytes());
            return rawBsonDocument;
        }
        catch (IOException e) {
            throw new BSONException("impossible", e);
        }
        finally {
            writer.close();
        }
    }

    @Override
    public Class<RawBsonDocument> getEncoderClass() {
        return RawBsonDocument.class;
    }

    private static class BufferExposingByteArrayOutputStream
    extends ByteArrayOutputStream {
        BufferExposingByteArrayOutputStream(int size) {
            super(size);
        }

        byte[] getInternalBytes() {
            return this.buf;
        }
    }
}

