/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsynchronousSocketChannelStream;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.SSLSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SSLSettings sslSettings;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SSLSettings sslSettings) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        if (this.sslSettings.isEnabled()) {
            throw new UnsupportedOperationException("No SSL support here.");
        }
        return new AsynchronousSocketChannelStream(serverAddress, this.settings, this.bufferProvider);
    }
}

