/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.concurrent.TimeUnit;

public class CountOptions {
    private Object hint;
    private String hintString;
    private long limit;
    private long maxTimeMS;
    private long skip;

    public Object getHint() {
        return this.hint;
    }

    public String getHintString() {
        return this.hintString;
    }

    public CountOptions hint(Object hint) {
        this.hint = hint;
        return this;
    }

    public CountOptions hintString(String hint) {
        this.hintString = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOptions limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOptions skip(long skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CountOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }
}

