/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.configuration.CodecRegistry;

class DistinctIterableImpl<T>
implements DistinctIterable<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final String fieldName;
    private Object filter;
    private long maxTimeMS;

    DistinctIterableImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, String fieldName) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.clazz = Assertions.notNull("clazz", clazz);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.executor = Assertions.notNull("executor", executor);
        this.fieldName = Assertions.notNull("mapFunction", fieldName);
    }

    @Override
    public DistinctIterable<T> filter(Object filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DistinctIterable<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctIterable<T> batchSize(int batchSize) {
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        DistinctOperation<T> operation = new DistinctOperation<T>(this.namespace, this.fieldName, this.codecRegistry.get(this.clazz)).filter(BsonDocumentWrapper.asBsonDocument(this.filter, this.codecRegistry)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        return new OperationIterable(operation, this.readPreference, this.executor);
    }
}

