/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ReadBinding;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.ReadOperation;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

public class DistinctOperation
implements AsyncReadOperation<BsonArray>,
ReadOperation<BsonArray> {
    private final MongoNamespace namespace;
    private final String fieldName;
    private BsonDocument filter;
    private long maxTimeMS;

    public DistinctOperation(MongoNamespace namespace, String fieldName) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fieldName = Assertions.notNull("fieldName", fieldName);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public DistinctOperation filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DistinctOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public BsonArray execute(ReadBinding binding) {
        return CommandOperationHelper.executeWrappedCommandProtocol(this.namespace.getDatabaseName(), this.getCommand(), binding, this.transformer());
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<BsonArray> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(this.namespace.getDatabaseName(), this.getCommand(), binding, this.transformer(), callback);
    }

    private Function<BsonDocument, BsonArray> transformer() {
        return new Function<BsonDocument, BsonArray>(){

            @Override
            public BsonArray apply(BsonDocument result) {
                return result.getArray("values");
            }
        };
    }

    private BsonDocument getCommand() {
        BsonDocument cmd = new BsonDocument("distinct", new BsonString(this.namespace.getCollectionName()));
        cmd.put("key", new BsonString(this.fieldName));
        DocumentHelper.putIfNotNull(cmd, "query", this.filter);
        DocumentHelper.putIfNotZero(cmd, "maxTimeMS", this.maxTimeMS);
        return cmd;
    }
}

