/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.annotations.Immutable;
import java.util.concurrent.TimeUnit;

@Immutable
public class ServerSettings {
    private final long heartbeatFrequencyMS;
    private final long minHeartbeatFrequencyMS;

    public static Builder builder() {
        return new Builder();
    }

    public long getHeartbeatFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.heartbeatFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public long getMinHeartbeatFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.minHeartbeatFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerSettings that = (ServerSettings)o;
        if (this.heartbeatFrequencyMS != that.heartbeatFrequencyMS) {
            return false;
        }
        return this.minHeartbeatFrequencyMS == that.minHeartbeatFrequencyMS;
    }

    public int hashCode() {
        int result = (int)(this.heartbeatFrequencyMS ^ this.heartbeatFrequencyMS >>> 32);
        result = 31 * result + (int)(this.minHeartbeatFrequencyMS ^ this.minHeartbeatFrequencyMS >>> 32);
        return result;
    }

    public String toString() {
        return "ServerSettings{heartbeatFrequencyMS=" + this.heartbeatFrequencyMS + ", minHeartbeatFrequencyMS=" + this.minHeartbeatFrequencyMS + '}';
    }

    ServerSettings(Builder builder) {
        this.heartbeatFrequencyMS = builder.heartbeatFrequencyMS;
        this.minHeartbeatFrequencyMS = builder.minHeartbeatFrequencyMS;
    }

    public static class Builder {
        private long heartbeatFrequencyMS = 5000L;
        private long minHeartbeatFrequencyMS = 10L;

        public Builder heartbeatFrequency(long heartbeatFrequency, TimeUnit timeUnit) {
            this.heartbeatFrequencyMS = TimeUnit.MILLISECONDS.convert(heartbeatFrequency, timeUnit);
            return this;
        }

        public Builder minHeartbeatFrequency(long minHeartbeatFrequency, TimeUnit timeUnit) {
            this.minHeartbeatFrequencyMS = TimeUnit.MILLISECONDS.convert(minHeartbeatFrequency, timeUnit);
            return this;
        }

        public ServerSettings build() {
            return new ServerSettings(this);
        }
    }
}

