/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public class MongoClientOptions {
    private final String description;
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final CodecRegistry codecRegistry;
    private final int minConnectionPoolSize;
    private final int maxConnectionPoolSize;
    private final int threadsAllowedToBlockForConnectionMultiplier;
    private final int serverSelectionTimeout;
    private final int maxWaitTime;
    private final int maxConnectionIdleTime;
    private final int maxConnectionLifeTime;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean socketKeepAlive;
    private final boolean sslEnabled;
    private final boolean alwaysUseMBeans;
    private final int heartbeatFrequency;
    private final int minHeartbeatFrequency;
    private final int heartbeatConnectTimeout;
    private final int heartbeatSocketTimeout;
    private final int localThreshold;
    private final String requiredReplicaSetName;
    private final DBDecoderFactory dbDecoderFactory;
    private final DBEncoderFactory dbEncoderFactory;
    private final SocketFactory socketFactory;
    private final boolean cursorFinalizerEnabled;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final SocketSettings socketSettings;
    private final ServerSettings serverSettings;
    private final SocketSettings heartbeatSocketSettings;

    private MongoClientOptions(Builder builder) {
        this.description = builder.description;
        this.minConnectionPoolSize = builder.minConnectionPoolSize;
        this.maxConnectionPoolSize = builder.maxConnectionPoolSize;
        this.threadsAllowedToBlockForConnectionMultiplier = builder.threadsAllowedToBlockForConnectionMultiplier;
        this.serverSelectionTimeout = builder.serverSelectionTimeout;
        this.maxWaitTime = builder.maxWaitTime;
        this.maxConnectionIdleTime = builder.maxConnectionIdleTime;
        this.maxConnectionLifeTime = builder.maxConnectionLifeTime;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.socketKeepAlive = builder.socketKeepAlive;
        this.readPreference = builder.readPreference;
        this.writeConcern = builder.writeConcern;
        this.codecRegistry = builder.codecRegistry;
        this.sslEnabled = builder.sslEnabled;
        this.alwaysUseMBeans = builder.alwaysUseMBeans;
        this.heartbeatFrequency = builder.heartbeatFrequency;
        this.minHeartbeatFrequency = builder.minHeartbeatFrequency;
        this.heartbeatConnectTimeout = builder.heartbeatConnectTimeout;
        this.heartbeatSocketTimeout = builder.heartbeatSocketTimeout;
        this.localThreshold = builder.localThreshold;
        this.requiredReplicaSetName = builder.requiredReplicaSetName;
        this.dbDecoderFactory = builder.dbDecoderFactory;
        this.dbEncoderFactory = builder.dbEncoderFactory;
        this.socketFactory = builder.socketFactory;
        this.cursorFinalizerEnabled = builder.cursorFinalizerEnabled;
        this.connectionPoolSettings = ConnectionPoolSettings.builder().minSize(this.getMinConnectionsPerHost()).maxSize(this.getConnectionsPerHost()).maxWaitQueueSize(this.getThreadsAllowedToBlockForConnectionMultiplier() * this.getConnectionsPerHost()).maxWaitTime(this.getMaxWaitTime(), TimeUnit.MILLISECONDS).maxConnectionIdleTime(this.getMaxConnectionIdleTime(), TimeUnit.MILLISECONDS).maxConnectionLifeTime(this.getMaxConnectionLifeTime(), TimeUnit.MILLISECONDS).build();
        this.socketSettings = SocketSettings.builder().connectTimeout(this.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.getSocketTimeout(), TimeUnit.MILLISECONDS).keepAlive(this.isSocketKeepAlive()).build();
        this.heartbeatSocketSettings = SocketSettings.builder().connectTimeout(this.getHeartbeatConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.getHeartbeatSocketTimeout(), TimeUnit.MILLISECONDS).keepAlive(this.isSocketKeepAlive()).build();
        this.serverSettings = ServerSettings.builder().heartbeatFrequency(this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS).minHeartbeatFrequency(this.getMinHeartbeatFrequency(), TimeUnit.MILLISECONDS).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public int getConnectionsPerHost() {
        return this.maxConnectionPoolSize;
    }

    public int getMinConnectionsPerHost() {
        return this.minConnectionPoolSize;
    }

    public int getThreadsAllowedToBlockForConnectionMultiplier() {
        return this.threadsAllowedToBlockForConnectionMultiplier;
    }

    public int getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public int getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public int getMinHeartbeatFrequency() {
        return this.minHeartbeatFrequency;
    }

    public int getHeartbeatConnectTimeout() {
        return this.heartbeatConnectTimeout;
    }

    public int getHeartbeatSocketTimeout() {
        return this.heartbeatSocketTimeout;
    }

    public int getLocalThreshold() {
        return this.localThreshold;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public DBDecoderFactory getDbDecoderFactory() {
        return this.dbDecoderFactory;
    }

    public DBEncoderFactory getDbEncoderFactory() {
        return this.dbEncoderFactory;
    }

    public boolean isAlwaysUseMBeans() {
        return this.alwaysUseMBeans;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientOptions that = (MongoClientOptions)o;
        if (this.localThreshold != that.localThreshold) {
            return false;
        }
        if (this.alwaysUseMBeans != that.alwaysUseMBeans) {
            return false;
        }
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.cursorFinalizerEnabled != that.cursorFinalizerEnabled) {
            return false;
        }
        if (this.minHeartbeatFrequency != that.minHeartbeatFrequency) {
            return false;
        }
        if (this.heartbeatConnectTimeout != that.heartbeatConnectTimeout) {
            return false;
        }
        if (this.heartbeatFrequency != that.heartbeatFrequency) {
            return false;
        }
        if (this.heartbeatSocketTimeout != that.heartbeatSocketTimeout) {
            return false;
        }
        if (this.maxConnectionIdleTime != that.maxConnectionIdleTime) {
            return false;
        }
        if (this.maxConnectionLifeTime != that.maxConnectionLifeTime) {
            return false;
        }
        if (this.maxConnectionPoolSize != that.maxConnectionPoolSize) {
            return false;
        }
        if (this.serverSelectionTimeout != that.serverSelectionTimeout) {
            return false;
        }
        if (this.maxWaitTime != that.maxWaitTime) {
            return false;
        }
        if (this.minConnectionPoolSize != that.minConnectionPoolSize) {
            return false;
        }
        if (this.socketKeepAlive != that.socketKeepAlive) {
            return false;
        }
        if (this.socketTimeout != that.socketTimeout) {
            return false;
        }
        if (this.sslEnabled != that.sslEnabled) {
            return false;
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != that.threadsAllowedToBlockForConnectionMultiplier) {
            return false;
        }
        if (this.dbDecoderFactory != null ? !this.dbDecoderFactory.equals(that.dbDecoderFactory) : that.dbDecoderFactory != null) {
            return false;
        }
        if (this.dbEncoderFactory != null ? !this.dbEncoderFactory.equals(that.dbEncoderFactory) : that.dbEncoderFactory != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.readPreference.equals(that.readPreference)) {
            return false;
        }
        if (!this.codecRegistry.equals(that.codecRegistry)) {
            return false;
        }
        if (this.requiredReplicaSetName != null ? !this.requiredReplicaSetName.equals(that.requiredReplicaSetName) : that.requiredReplicaSetName != null) {
            return false;
        }
        return this.socketFactory.getClass().equals(that.socketFactory.getClass());
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + this.readPreference.hashCode();
        result = 31 * result + this.writeConcern.hashCode();
        result = 31 * result + this.codecRegistry.hashCode();
        result = 31 * result + this.minConnectionPoolSize;
        result = 31 * result + this.maxConnectionPoolSize;
        result = 31 * result + this.threadsAllowedToBlockForConnectionMultiplier;
        result = 31 * result + this.serverSelectionTimeout;
        result = 31 * result + this.maxWaitTime;
        result = 31 * result + this.maxConnectionIdleTime;
        result = 31 * result + this.maxConnectionLifeTime;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.socketTimeout;
        result = 31 * result + (this.socketKeepAlive ? 1 : 0);
        result = 31 * result + (this.sslEnabled ? 1 : 0);
        result = 31 * result + (this.alwaysUseMBeans ? 1 : 0);
        result = 31 * result + this.heartbeatFrequency;
        result = 31 * result + this.minHeartbeatFrequency;
        result = 31 * result + this.heartbeatConnectTimeout;
        result = 31 * result + this.heartbeatSocketTimeout;
        result = 31 * result + this.localThreshold;
        result = 31 * result + (this.requiredReplicaSetName != null ? this.requiredReplicaSetName.hashCode() : 0);
        result = 31 * result + (this.dbDecoderFactory != null ? this.dbDecoderFactory.hashCode() : 0);
        result = 31 * result + (this.dbEncoderFactory != null ? this.dbEncoderFactory.hashCode() : 0);
        result = 31 * result + (this.cursorFinalizerEnabled ? 1 : 0);
        result = 31 * result + this.socketFactory.getClass().hashCode();
        return result;
    }

    public String toString() {
        return "MongoClientOptions{description='" + this.description + '\'' + ", readPreference=" + this.readPreference + ", writeConcern=" + this.writeConcern + ", codecRegistry=" + this.codecRegistry + ", minConnectionPoolSize=" + this.minConnectionPoolSize + ", maxConnectionPoolSize=" + this.maxConnectionPoolSize + ", threadsAllowedToBlockForConnectionMultiplier=" + this.threadsAllowedToBlockForConnectionMultiplier + ", serverSelectionTimeout=" + this.serverSelectionTimeout + ", maxWaitTime=" + this.maxWaitTime + ", maxConnectionIdleTime=" + this.maxConnectionIdleTime + ", maxConnectionLifeTime=" + this.maxConnectionLifeTime + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", socketKeepAlive=" + this.socketKeepAlive + ", sslEnabled=" + this.sslEnabled + ", alwaysUseMBeans=" + this.alwaysUseMBeans + ", heartbeatFrequency=" + this.heartbeatFrequency + ", minHeartbeatFrequency=" + this.minHeartbeatFrequency + ", heartbeatConnectTimeout=" + this.heartbeatConnectTimeout + ", heartbeatSocketTimeout=" + this.heartbeatSocketTimeout + ", localThreshold=" + this.localThreshold + ", requiredReplicaSetName='" + this.requiredReplicaSetName + '\'' + ", dbDecoderFactory=" + this.dbDecoderFactory + ", dbEncoderFactory=" + this.dbEncoderFactory + ", socketFactory=" + this.socketFactory + ", cursorFinalizerEnabled=" + this.cursorFinalizerEnabled + ", connectionPoolSettings=" + this.connectionPoolSettings + ", socketSettings=" + this.socketSettings + ", serverSettings=" + this.serverSettings + ", heartbeatSocketSettings=" + this.heartbeatSocketSettings + '}';
    }

    public static class Builder {
        private String description;
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private CodecRegistry codecRegistry = MongoClient.getDefaultCodecRegistry();
        private int minConnectionPoolSize;
        private int maxConnectionPoolSize = 100;
        private int threadsAllowedToBlockForConnectionMultiplier = 5;
        private int serverSelectionTimeout = 30000;
        private int maxWaitTime = 120000;
        private int maxConnectionIdleTime;
        private int maxConnectionLifeTime;
        private int connectTimeout = 10000;
        private int socketTimeout = 0;
        private boolean socketKeepAlive = false;
        private boolean sslEnabled = false;
        private boolean alwaysUseMBeans = false;
        private int heartbeatFrequency = 10000;
        private int minHeartbeatFrequency = 10;
        private int heartbeatConnectTimeout = 20000;
        private int heartbeatSocketTimeout = 20000;
        private int localThreshold = 15;
        private String requiredReplicaSetName;
        private DBDecoderFactory dbDecoderFactory = DefaultDBDecoder.FACTORY;
        private DBEncoderFactory dbEncoderFactory = DefaultDBEncoder.FACTORY;
        private SocketFactory socketFactory = SocketFactory.getDefault();
        private boolean cursorFinalizerEnabled = true;

        public Builder() {
            this.heartbeatFrequency(Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "5000")));
            this.minHeartbeatFrequency(Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalNoMasterMS", "10")));
            this.heartbeatConnectTimeout(Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000")));
            this.heartbeatSocketTimeout(Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000")));
            this.localThreshold(Integer.parseInt(System.getProperty("com.mongodb.slaveAcceptableLatencyMS", "15")));
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder minConnectionsPerHost(int minConnectionsPerHost) {
            Assertions.isTrueArgument("minConnectionsPerHost must be >= 0", minConnectionsPerHost >= 0);
            this.minConnectionPoolSize = minConnectionsPerHost;
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            Assertions.isTrueArgument("connectionPerHost must be > 0", connectionsPerHost > 0);
            this.maxConnectionPoolSize = connectionsPerHost;
            return this;
        }

        public Builder threadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
            Assertions.isTrueArgument("threadsAllowedToBlockForConnectionMultiplier must be > 0", threadsAllowedToBlockForConnectionMultiplier > 0);
            this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
            return this;
        }

        public Builder serverSelectionTimeout(int serverSelectionTimeout) {
            this.serverSelectionTimeout = serverSelectionTimeout;
            return this;
        }

        public Builder maxWaitTime(int maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder maxConnectionIdleTime(int maxConnectionIdleTime) {
            this.maxConnectionIdleTime = maxConnectionIdleTime;
            return this;
        }

        public Builder maxConnectionLifeTime(int maxConnectionLifeTime) {
            this.maxConnectionLifeTime = maxConnectionLifeTime;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            Assertions.isTrueArgument("connectTimeout must be >= 0", connectTimeout >= 0);
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            this.socketFactory(sslEnabled ? SSLSocketFactory.getDefault() : SocketFactory.getDefault());
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = Assertions.notNull("readPreference", readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder cursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
            this.cursorFinalizerEnabled = cursorFinalizerEnabled;
            return this;
        }

        public Builder alwaysUseMBeans(boolean alwaysUseMBeans) {
            this.alwaysUseMBeans = alwaysUseMBeans;
            return this;
        }

        public Builder dbDecoderFactory(DBDecoderFactory dbDecoderFactory) {
            if (dbDecoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbDecoderFactory = dbDecoderFactory;
            return this;
        }

        public Builder dbEncoderFactory(DBEncoderFactory dbEncoderFactory) {
            if (dbEncoderFactory == null) {
                throw new IllegalArgumentException("null is not a legal value");
            }
            this.dbEncoderFactory = dbEncoderFactory;
            return this;
        }

        public Builder heartbeatFrequency(int heartbeatFrequency) {
            Assertions.isTrueArgument("heartbeatFrequency must be > 0", heartbeatFrequency > 0);
            this.heartbeatFrequency = heartbeatFrequency;
            return this;
        }

        public Builder minHeartbeatFrequency(int minHeartbeatFrequency) {
            Assertions.isTrueArgument("minHeartbeatFrequency must be > 0", minHeartbeatFrequency > 0);
            this.minHeartbeatFrequency = minHeartbeatFrequency;
            return this;
        }

        public Builder heartbeatConnectTimeout(int connectTimeout) {
            this.heartbeatConnectTimeout = connectTimeout;
            return this;
        }

        public Builder heartbeatSocketTimeout(int socketTimeout) {
            this.heartbeatSocketTimeout = socketTimeout;
            return this;
        }

        public Builder localThreshold(int localThreshold) {
            Assertions.isTrueArgument("localThreshold must be >= 0", localThreshold >= 0);
            this.localThreshold = localThreshold;
            return this;
        }

        public Builder requiredReplicaSetName(String requiredReplicaSetName) {
            this.requiredReplicaSetName = requiredReplicaSetName;
            return this;
        }

        public Builder legacyDefaults() {
            this.connectionsPerHost(10).writeConcern(WriteConcern.UNACKNOWLEDGED);
            return this;
        }

        public MongoClientOptions build() {
            return new MongoClientOptions(this);
        }
    }
}

