/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionsFluent;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

final class ListCollectionsFluentImpl<T>
implements ListCollectionsFluent<T> {
    private final String databaseName;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private Object filter;
    private int batchSize;
    private long maxTimeMS;

    ListCollectionsFluentImpl(String databaseName, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.clazz = Assertions.notNull("clazz", clazz);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public ListCollectionsFluent<T> filter(Object filter) {
        Assertions.notNull("filter", filter);
        this.filter = filter;
        return this;
    }

    @Override
    public ListCollectionsFluent<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsFluent<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.execute().iterator();
    }

    @Override
    public T first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return this.execute().map(mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super T>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<T> execute() {
        return new OperationIterable(this.createListCollectionsOperation(), this.readPreference, this.executor);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private ListCollectionsOperation<T> createListCollectionsOperation() {
        return new ListCollectionsOperation<T>(this.databaseName, this.getCodec(this.clazz)).filter(this.asBson(this.filter)).batchSize(this.batchSize).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument(document, this.codecRegistry);
    }
}

