/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBPort;
import com.mongodb.WriteConcern;

public class WriteResult {
    private long _lastCall;
    private WriteConcern _lastConcern;
    private CommandResult _lastErrorResult;
    private final DB _db;
    private final DBPort _port;
    private final boolean _lazy;

    WriteResult(CommandResult o, WriteConcern concern) {
        this._lastErrorResult = o;
        this._lastConcern = concern;
        this._lazy = false;
        this._port = null;
        this._db = null;
    }

    WriteResult(DB db, DBPort p, WriteConcern concern) {
        this._db = db;
        this._port = p;
        this._lastCall = p._calls;
        this._lastConcern = concern;
        this._lazy = true;
    }

    public CommandResult getCachedLastError() {
        return this._lastErrorResult;
    }

    public WriteConcern getLastConcern() {
        return this._lastConcern;
    }

    public synchronized CommandResult getLastError() {
        return this.getLastError(null);
    }

    public synchronized CommandResult getLastError(WriteConcern concern) {
        if (this._lastErrorResult != null && (this._lastConcern != null && this._lastConcern.equals(concern) || concern != null && concern.equals(this._lastConcern))) {
            return this._lastErrorResult;
        }
        if (this._port != null) {
            this._lastErrorResult = this._port.tryGetLastError(this._db, this._lastCall, concern == null ? new WriteConcern() : concern);
            this._lastConcern = concern;
        }
        if (this._lastErrorResult == null) {
            throw new IllegalStateException("The connection has been used since the last call, can't call getLastError anymore");
        }
        ++this._lastCall;
        return this._lastErrorResult;
    }

    public String getError() {
        Object foo = this.getField("err");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public int getN() {
        return this.getLastError().getInt("n");
    }

    public Object getField(String name) {
        return this.getLastError().get(name);
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public String toString() {
        return this.getLastError().toString();
    }
}

