/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ChangeEvent;
import com.mongodb.ChangeListener;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Loggers;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.ServerConnectionState;
import com.mongodb.ServerDescription;
import com.mongodb.ServerType;
import com.mongodb.ServerVersion;
import com.mongodb.SocketSettings;
import com.mongodb.Tags;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.util.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class ServerStateNotifier
implements Runnable {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private ServerAddress serverAddress;
    private final ChangeListener<ServerDescription> serverStateListener;
    private final SocketSettings socketSettings;
    private final Mongo mongo;
    private int count;
    private long elapsedNanosSum;
    private volatile ServerDescription serverDescription;
    private volatile boolean isClosed;
    DBPort connection;

    ServerStateNotifier(ServerAddress serverAddress, ChangeListener<ServerDescription> serverStateListener, SocketSettings socketSettings, Mongo mongo) {
        this.serverAddress = serverAddress;
        this.serverStateListener = serverStateListener;
        this.socketSettings = socketSettings;
        this.mongo = mongo;
        this.serverDescription = this.getConnectingServerDescription();
    }

    @Override
    public synchronized void run() {
        if (this.isClosed) {
            return;
        }
        ServerDescription currentServerDescription = this.serverDescription;
        Throwable throwable = null;
        try {
            if (this.connection == null) {
                this.connection = new DBPort(this.serverAddress, null, this.getOptions(), 0);
            }
            try {
                LOGGER.fine(String.format("Checking status of %s", this.serverAddress));
                long startNanoTime = System.nanoTime();
                CommandResult isMasterResult = this.connection.runCommand(this.mongo.getDB("admin"), new BasicDBObject("ismaster", (Object)1));
                ++this.count;
                this.elapsedNanosSum += System.nanoTime() - startNanoTime;
                CommandResult buildInfoResult = this.connection.runCommand(this.mongo.getDB("admin"), new BasicDBObject("buildinfo", (Object)1));
                this.serverDescription = this.createDescription(isMasterResult, buildInfoResult, this.elapsedNanosSum / (long)this.count);
            }
            catch (IOException e) {
                if (!this.isClosed) {
                    this.connection.close();
                    this.connection = null;
                    this.count = 0;
                    this.elapsedNanosSum = 0L;
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            throwable = t;
            this.serverDescription = this.getUnconnectedServerDescription();
        }
        if (!this.isClosed) {
            try {
                if (!currentServerDescription.equals(this.serverDescription)) {
                    if (throwable != null) {
                        LOGGER.log(Level.INFO, String.format("Exception in monitor thread while connecting to server %s", this.serverAddress), throwable);
                    } else {
                        LOGGER.info(String.format("Monitor thread successfully connected to server with description %s", this.serverDescription));
                    }
                }
                this.serverStateListener.stateChanged(new ChangeEvent<ServerDescription>(currentServerDescription, this.serverDescription));
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Exception in monitor thread during notification of server description state change", t);
            }
        }
    }

    public void close() {
        this.isClosed = true;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private MongoOptions getOptions() {
        MongoOptions options = new MongoOptions();
        options.setConnectTimeout(this.socketSettings.getConnectTimeout(TimeUnit.MILLISECONDS));
        options.setSocketTimeout(this.socketSettings.getReadTimeout(TimeUnit.MILLISECONDS));
        options.setSocketFactory(this.socketSettings.getSocketFactory());
        return options;
    }

    private ServerDescription createDescription(CommandResult commandResult, CommandResult buildInfoResult, long averagePingTimeNanos) {
        return ServerDescription.builder().state(ServerConnectionState.Connected).version(ServerStateNotifier.getVersion(buildInfoResult)).address(commandResult.getServerUsed()).type(ServerStateNotifier.getServerType(commandResult)).hosts(this.listToSet((List)commandResult.get("hosts"))).passives(this.listToSet((List)commandResult.get("passives"))).arbiters(this.listToSet((List)commandResult.get("arbiters"))).primary(commandResult.getString("primary")).maxDocumentSize(commandResult.getInt("maxBsonObjectSize", ServerDescription.getDefaultMaxDocumentSize())).maxMessageSize(commandResult.getInt("maxMessageSizeBytes", ServerDescription.getDefaultMaxMessageSize())).maxWriteBatchSize(commandResult.getInt("maxWriteBatchSize", ServerDescription.getDefaultMaxWriteBatchSize())).tags(ServerStateNotifier.getTagsFromDocument((DBObject)commandResult.get("tags"))).setName(commandResult.getString("setName")).setVersion((Integer)commandResult.get("setVersion")).minWireVersion(commandResult.getInt("minWireVersion", ServerDescription.getDefaultMinWireVersion())).maxWireVersion(commandResult.getInt("maxWireVersion", ServerDescription.getDefaultMaxWireVersion())).averagePingTime(averagePingTimeNanos, TimeUnit.NANOSECONDS).ok(commandResult.ok()).build();
    }

    private static ServerVersion getVersion(CommandResult buildInfoResult) {
        return new ServerVersion(((List)buildInfoResult.get("versionArray")).subList(0, 3));
    }

    private Set<String> listToSet(List<String> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(list);
    }

    private static ServerType getServerType(BasicDBObject isMasterResult) {
        if (ServerStateNotifier.isReplicaSetMember(isMasterResult)) {
            if (isMasterResult.getBoolean("ismaster", false)) {
                return ServerType.ReplicaSetPrimary;
            }
            if (isMasterResult.getBoolean("secondary", false)) {
                return ServerType.ReplicaSetSecondary;
            }
            if (isMasterResult.getBoolean("arbiterOnly", false)) {
                return ServerType.ReplicaSetArbiter;
            }
            return ServerType.ReplicaSetOther;
        }
        if (isMasterResult.containsKey("msg") && isMasterResult.get("msg").equals("isdbgrid")) {
            return ServerType.ShardRouter;
        }
        return ServerType.StandAlone;
    }

    private static boolean isReplicaSetMember(BasicDBObject isMasterResult) {
        return isMasterResult.containsKey("setName") || isMasterResult.getBoolean("isreplicaset", false);
    }

    private static Tags getTagsFromDocument(DBObject tagsDocuments) {
        if (tagsDocuments == null) {
            return new Tags();
        }
        Tags tags = new Tags();
        for (String key : tagsDocuments.keySet()) {
            tags.put(key, tagsDocuments.get(key).toString());
        }
        return tags;
    }

    private ServerDescription getConnectingServerDescription() {
        return ServerDescription.builder().type(ServerType.Unknown).state(ServerConnectionState.Connecting).address(this.serverAddress).build();
    }

    private ServerDescription getUnconnectedServerDescription() {
        return ServerDescription.builder().type(ServerType.Unknown).state(ServerConnectionState.Unconnected).address(this.serverAddress).build();
    }
}

