/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BSONBinaryWriter;
import com.mongodb.BaseWriteCommandMessage;
import com.mongodb.DBEncoder;
import com.mongodb.MessageSettings;
import com.mongodb.ModifyRequest;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import java.util.List;
import org.bson.io.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateCommandMessage
extends BaseWriteCommandMessage {
    private final List<ModifyRequest> updates;
    private final DBEncoder encoder;

    public UpdateCommandMessage(MongoNamespace writeNamespace, WriteConcern writeConcern, List<ModifyRequest> updates, DBEncoder commandEncoder, DBEncoder encoder, MessageSettings settings) {
        super(writeNamespace, writeConcern, commandEncoder, settings);
        this.updates = updates;
        this.encoder = encoder;
    }

    @Override
    protected UpdateCommandMessage writeTheWrites(OutputBuffer buffer, int commandStartPosition, BSONBinaryWriter writer) {
        UpdateCommandMessage nextMessage = null;
        writer.writeStartArray("updates");
        for (int i = 0; i < this.updates.size(); ++i) {
            writer.mark();
            ModifyRequest update = this.updates.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            writer.encodeDocument(this.getCommandEncoder(), update.getQuery());
            writer.writeName("u");
            writer.encodeDocument(this.encoder, update.getUpdateDocument());
            writer.writeBoolean("multi", update.isMulti());
            writer.writeBoolean("upsert", update.isUpsert());
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.maximumCommandDocumentSizeExceeded(buffer, commandStartPosition)) continue;
            writer.reset();
            nextMessage = new UpdateCommandMessage(this.getWriteNamespace(), this.getWriteConcern(), this.updates.subList(i, this.updates.size()), this.getCommandEncoder(), this.encoder, this.getSettings());
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.updates.size();
    }

    @Override
    protected String getCommandName() {
        return "update";
    }
}

