/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBCollection;
import com.mongodb.DBPointer;
import com.mongodb.DBRefBase;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.io.PoolOutputBuffer;
import org.bson.types.ObjectId;

class OutMessage
extends BSONEncoder {
    static AtomicInteger ID = new AtomicInteger(1);
    static ThreadLocal<OutMessage> TL = new ThreadLocal<OutMessage>(){

        @Override
        protected OutMessage initialValue() {
            return new OutMessage();
        }
    };
    private PoolOutputBuffer _buffer = new PoolOutputBuffer();
    private int _id;

    static OutMessage get(int op) {
        OutMessage m = TL.get();
        m.reset(op);
        return m;
    }

    OutMessage() {
        this.set(this._buffer);
    }

    private void reset(int op) {
        this.done();
        this._buffer.reset();
        this.set(this._buffer);
        this._id = ID.getAndIncrement();
        this.writeInt(0);
        this.writeInt(this._id);
        this.writeInt(0);
        this.writeInt(op);
    }

    void prepare() {
        this._buffer.writeInt(0, this._buffer.size());
    }

    protected boolean handleSpecialObjects(String name, BSONObject o) {
        if (o == null) {
            return false;
        }
        if (o instanceof DBCollection) {
            DBCollection c = (DBCollection)((Object)o);
            this.putDBPointer(name, c.getName(), Bytes.COLLECTION_REF_ID);
            return true;
        }
        if (name != null && o instanceof DBPointer) {
            DBPointer r = (DBPointer)((Object)o);
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
            return true;
        }
        return false;
    }

    protected boolean putSpecial(String name, Object val) {
        if (val instanceof DBPointer) {
            DBPointer r = (DBPointer)val;
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
            return true;
        }
        if (val instanceof DBRefBase) {
            this.putDBRef(name, (DBRefBase)val);
            return true;
        }
        return false;
    }

    protected void putDBPointer(String name, String ns, ObjectId oid) {
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.writeInt(oid._time());
        this._buf.writeInt(oid._machine());
        this._buf.writeInt(oid._inc());
    }

    protected void putDBRef(String name, DBRefBase ref) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putObjectField("$ref", ref.getRef());
        this._putObjectField("$id", ref.getId());
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    void pipe(OutputStream out) throws IOException {
        this._buffer.pipe(out);
    }

    int size() {
        return this._buffer.size();
    }

    byte[] toByteArray() {
        return this._buffer.toByteArray();
    }
}

