/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import org.bson.BSONObject;

public class ServerError {
    final String _err;
    final int _code;

    ServerError(DBObject o) {
        Object foo = o.get("$err");
        if (foo == null) {
            throw new IllegalArgumentException("need to have $err");
        }
        this._err = foo.toString();
        this._code = ServerError._getCode(o);
    }

    static int _getCode(BSONObject o) {
        Object c = o.get("code");
        if (c == null) {
            c = o.get("$code");
        }
        if (c == null) {
            return -5;
        }
        return ((Number)c).intValue();
    }

    public String getError() {
        return this._err;
    }

    public int getCode() {
        return this._code;
    }

    public boolean isNotMasterError() {
        return this._err.equals("not master") || this._code == 10054 || this._code == 10056 || this._code == 10058 || this._code == 10107;
    }

    public String toString() {
        if (this._code > 0) {
            return this._code + " " + this._err;
        }
        return this._err;
    }
}

