/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBTCPConnector
implements DBConnector {
    static Logger _logger = Logger.getLogger(Bytes.LOGGER.getName() + ".tcp");
    static Logger _createLogger = Logger.getLogger(_logger.getName() + ".connect");
    final Mongo _mongo;
    private ServerAddress _curAddress;
    private DBPortPool _curPortPool;
    private DBPortPool.Holder _portHolder;
    private final List<ServerAddress> _allHosts;
    private final ThreadLocal<MyPort> _threadPort = new ThreadLocal<MyPort>(){

        @Override
        protected MyPort initialValue() {
            return new MyPort();
        }
    };
    private static final DBObject _isMaster = BasicDBObjectBuilder.start().add("ismaster", 1).get();

    public DBTCPConnector(Mongo m, ServerAddress addr) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(addr);
        _createLogger.info(addr.toString());
        if (addr.isPaired()) {
            this._allHosts = new ArrayList<ServerAddress>(addr.explode());
            _createLogger.info("switch to paired mode : " + this._allHosts + " -> " + this._curAddress);
        } else {
            this._set(addr);
            this._allHosts = null;
        }
    }

    public DBTCPConnector(Mongo m, ServerAddress ... all) throws MongoException {
        this(m, Arrays.asList(all));
    }

    public DBTCPConnector(Mongo m, List<ServerAddress> all) throws MongoException {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(all);
        this._allHosts = new ArrayList<ServerAddress>(all);
        _createLogger.info(all + " -> " + this._curAddress);
    }

    private static ServerAddress _checkAddress(ServerAddress addr) {
        if (addr == null) {
            throw new NullPointerException("address can't be null");
        }
        return addr;
    }

    private static ServerAddress _checkAddress(List<ServerAddress> addrs) {
        if (addrs == null) {
            throw new NullPointerException("addresses can't be null");
        }
        if (addrs.size() == 0) {
            throw new IllegalArgumentException("need to specify at least 1 address");
        }
        return addrs.get(0);
    }

    @Override
    public void requestStart() {
        this._threadPort.get().requestStart();
    }

    @Override
    public void requestDone() {
        this._threadPort.get().requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._threadPort.get().requestEnsureConnection();
    }

    void _checkWriteError() throws MongoException {
        DBObject e = this._mongo.getDB("admin").getLastError();
        Object foo = e.get("err");
        if (foo == null) {
            return;
        }
        int code = -1;
        if (e.get("code") instanceof Number) {
            code = ((Number)e.get("code")).intValue();
        }
        String s = foo.toString();
        if (code == 11000 || code == 11001 || s.startsWith("E11000") || s.startsWith("E11001")) {
            throw new MongoException.DuplicateKey(code, s);
        }
        throw new MongoException(code, s);
    }

    @Override
    public void say(DB db, OutMessage m, DB.WriteConcern concern) throws MongoException {
        MyPort mp = this._threadPort.get();
        DBPort port = mp.get(true);
        port.checkAuth(db);
        try {
            port.say(m);
            if (concern == DB.WriteConcern.STRICT) {
                this._checkWriteError();
            }
            mp.done(port);
        }
        catch (IOException ioe) {
            mp.error(ioe);
            this._error(ioe);
            if (concern == DB.WriteConcern.NONE) {
                return;
            }
            throw new MongoException.Network("can't say something", ioe);
        }
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m) throws MongoException {
        return this.call(db, coll, m, 2);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, int retries) throws MongoException {
        MyPort mp = this._threadPort.get();
        DBPort port = mp.get(false);
        port.checkAuth(db);
        try {
            Response res = port.call(m, coll);
            res.addHook(new MyDoneHook(mp, port));
            String err = this._getError(res.peek());
            if (err != null && "not master".equals(err)) {
                this._pickCurrent();
                if (retries <= 0) {
                    throw new MongoException("not talking to master and retries used up");
                }
                return this.call(db, coll, m, retries - 1);
            }
            return res;
        }
        catch (IOException ioe) {
            mp.error(ioe);
            if (this._error(ioe) && retries > 0) {
                return this.call(db, coll, m, retries - 1);
            }
            throw new MongoException.Network("can't call something", ioe);
        }
    }

    public ServerAddress getAddress() {
        return this._curAddress;
    }

    public List<ServerAddress> getAllAddress() {
        return this._allHosts;
    }

    public String getConnectPoint() {
        return this._curAddress.toString();
    }

    boolean _error(Throwable t) throws MongoException {
        if (this._allHosts != null) {
            System.out.println("paired mode, switching master b/c of: " + t);
            t.printStackTrace();
            this._pickCurrent();
        }
        return true;
    }

    String _getError(BSONObject obj) {
        if (obj == null) {
            return null;
        }
        Object err = obj.get("$err");
        if (err == null) {
            return null;
        }
        return err.toString();
    }

    void _pickInitial() throws MongoException {
        if (this._curAddress != null) {
            return;
        }
        this._pickCurrent();
        try {
            _logger.info("current address beginning of _pickInitial: " + this._curAddress);
            DBObject im = this.isMasterCmd();
            if (this._isMaster(im)) {
                return;
            }
            List<ServerAddress> list = this._allHosts;
            synchronized (list) {
                Collections.shuffle(this._allHosts);
                for (ServerAddress a : this._allHosts) {
                    if (this._curAddress == a) continue;
                    _logger.info("remote [" + this._curAddress + "] -> [" + a + "]");
                    this._set(a);
                    im = this.isMasterCmd();
                    if (this._isMaster(im)) {
                        return;
                    }
                    _logger.severe("switched to: " + a + " but isn't master");
                }
                throw new MongoException("can't find master");
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "can't pick initial master, using random one", e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _pickCurrent() throws MongoException {
        if (this._allHosts == null) {
            throw new MongoException("got master/slave issue but not in master/slave mode on the client side");
        }
        List<ServerAddress> list = this._allHosts;
        synchronized (list) {
            Collections.shuffle(this._allHosts);
            for (int i = 0; i < this._allHosts.size(); ++i) {
                ServerAddress a = this._allHosts.get(i);
                if (a == this._curAddress) continue;
                if (this._curAddress != null) {
                    _logger.info("switching from [" + this._curAddress + "] to [" + a + "]");
                }
                this._set(a);
                return;
            }
        }
        throw new MongoException("couldn't find a new host to swtich too");
    }

    private boolean _set(ServerAddress addr) {
        if (this._curAddress == addr) {
            return false;
        }
        this._curAddress = addr;
        this._curPortPool = this._portHolder.get(this._curAddress.getSocketAddress());
        return true;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder("DBTCPConnector: ");
        if (this._allHosts != null) {
            buf.append("paired : ").append(this._allHosts);
        } else {
            buf.append(this._curAddress).append(" ").append(this._curAddress._addr);
        }
        return buf.toString();
    }

    DBObject isMasterCmd() {
        DBCollection collection = this._mongo.getDB("admin").getCollection("$cmd");
        Iterator<DBObject> i = collection.find(_isMaster, null, 0, 1, 0);
        if (i == null || !i.hasNext()) {
            throw new MongoException("no result for ismaster query?");
        }
        DBObject res = i.next();
        if (i.hasNext()) {
            throw new MongoException("what's going on");
        }
        return res;
    }

    boolean _isMaster(DBObject res) {
        Object x = res.get("ismaster");
        if (x == null) {
            throw new IllegalStateException("ismaster shouldn't be null: " + res);
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            return ((Number)x).intValue() == 1;
        }
        throw new IllegalArgumentException("invalid ismaster [" + x + "] : " + x.getClass().getName());
    }

    static class MyDoneHook
    implements Response.DoneHook {
        final MyPort _mp;
        final DBPort _dp;

        MyDoneHook(MyPort mp, DBPort dp) {
            this._mp = mp;
            this._dp = dp;
        }

        public void done() {
            this._mp.done(this._dp);
        }

        public void error(IOException ioe) {
            this._mp.error(ioe);
        }
    }

    class MyPort {
        int _internalStack = 0;
        DBPort _port;
        DBPort _last;
        boolean _inRequest;

        MyPort() {
        }

        DBPort get(boolean keep) {
            ++this._internalStack;
            if (this._internalStack > 1) {
                if (this._last == null) {
                    System.err.println("_internalStack > 1 and _last is null!");
                } else {
                    return this._last;
                }
            }
            if (this._port != null) {
                return this._port;
            }
            DBPort p = DBTCPConnector.this._curPortPool.get();
            if (keep && this._inRequest) {
                this._port = p;
            }
            this._last = p;
            return p;
        }

        void done(DBPort p) {
            --this._internalStack;
            if (p != this._port && this._internalStack <= 0) {
                DBTCPConnector.this._curPortPool.done(p);
            }
            if (this._internalStack < 0) {
                System.err.println("_internalStack < 0 : " + this._internalStack);
                this._internalStack = 0;
            }
        }

        void error(Exception e) {
            this._port = null;
            DBTCPConnector.this._curPortPool.gotError(e);
            this._internalStack = 0;
            this._last = null;
        }

        void requestEnsureConnection() {
            if (!this._inRequest) {
                return;
            }
            if (this._port != null) {
                return;
            }
            this._port = DBTCPConnector.this._curPortPool.get();
        }

        void requestStart() {
            this._inRequest = true;
            if (this._port != null) {
                this._port = null;
                System.err.println("ERROR.  somehow _port was not null at requestStart");
            }
        }

        void requestDone() {
            if (this._port != null) {
                DBTCPConnector.this._curPortPool.done(this._port);
            }
            this._port = null;
            this._inRequest = false;
            if (this._internalStack > 0) {
                System.err.println("_internalStack in requestDone should be 0");
                this._internalStack = 0;
            }
        }
    }
}

