/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ByteEncoder;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class DBMessage {
    static AtomicInteger ID = new AtomicInteger(1);
    static int HEADER_LENGTH = 16;
    private State _state;
    private int _len;
    final int _id;
    final int _responseTo;
    final int _operation;
    final ByteEncoder _encoder;
    final ByteBuffer _buf;

    DBMessage(int operation) {
        this._len = 0;
        this._id = ID.getAndIncrement();
        this._responseTo = 0;
        this._operation = operation;
        this._encoder = ByteEncoder.get();
        this._buf = this._encoder._buf;
        this._buf.putInt(0);
        this._buf.putInt(this._id);
        this._buf.putInt(this._responseTo);
        this._buf.putInt(this._operation);
        this._state = State.BUILDING;
    }

    DBMessage(ByteBuffer buf) {
        this._buf = buf;
        this._len = buf.getInt();
        this._id = buf.getInt();
        this._responseTo = buf.getInt();
        this._operation = buf.getInt();
        this._state = State.READABLE;
        this._encoder = null;
    }

    ByteBuffer forBuilding() {
        if (this._state != State.BUILDING) {
            throw new IllegalStateException();
        }
        if (this._buf.position() != HEADER_LENGTH) {
            throw new IllegalStateException();
        }
        return this._buf;
    }

    ByteBuffer prepare() {
        if (this._state != State.BUILDING) {
            throw new IllegalStateException();
        }
        if (this._buf.position() <= HEADER_LENGTH) {
            throw new IllegalStateException();
        }
        this._state = State.SENDING;
        this._len = this._buf.position();
        this._buf.putInt(0, this._len);
        this._buf.flip();
        return this._buf;
    }

    ByteBuffer forReading() {
        if (this._state != State.READABLE) {
            throw new IllegalStateException();
        }
        if (this._buf.position() != HEADER_LENGTH) {
            throw new IllegalStateException();
        }
        this._state = State.DONE;
        return this._buf;
    }

    public String toString() {
        return "DBMessage len: " + this._len + " id: " + this._id + " responseTo: " + this._responseTo + " operation: " + this._operation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        BUILDING,
        SENDING,
        READABLE,
        DONE;

    }
}

