/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.util.Args;
import com.mongodb.util.MyAsserts;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TestCase
extends MyAsserts {
    final List<Test> _tests = new ArrayList<Test>();

    public TestCase() {
        this(null);
    }

    public TestCase(String name) {
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().startsWith("test") || (m.getModifiers() & 0) > 0) continue;
            Test t = new Test(this, m);
            t._name = name;
            this._tests.add(t);
        }
    }

    public TestCase(Object o, String m) throws NoSuchMethodException {
        this(o, o.getClass().getDeclaredMethod(m, new Class[0]));
    }

    public TestCase(Object o, Method m) {
        this._tests.add(new Test(o, m));
    }

    public void add(TestCase tc) {
        this._tests.addAll(tc._tests);
    }

    public boolean runConsole() {
        ArrayList<Result> errors = new ArrayList<Result>();
        ArrayList<Result> fails = new ArrayList<Result>();
        System.out.println("Num Tests : " + this._tests.size());
        System.out.println("----");
        for (Test t : this._tests) {
            Result r = t.run();
            if (r.ok()) {
                System.out.print(".");
                continue;
            }
            System.out.print("x");
            if (r._error instanceof MyAsserts.MyAssert) {
                fails.add(r);
                continue;
            }
            errors.add(r);
        }
        System.out.println("\n----");
        int pass = this._tests.size() - (errors.size() + fails.size());
        System.out.println("Passes : " + pass + " / " + this._tests.size());
        System.out.println("% Pass : " + (double)pass * 100.0 / (double)this._tests.size());
        if (pass == this._tests.size()) {
            System.out.println("SUCCESS");
            return true;
        }
        System.err.println("Num Pass : " + (this._tests.size() - (errors.size() + fails.size())));
        System.err.println("Num Erros : " + errors.size());
        System.err.println("Num Fails : " + fails.size());
        System.err.println("---------");
        System.err.println("ERRORS");
        for (Result r : errors) {
            System.err.println(r);
        }
        System.err.println("---------");
        System.err.println("FAILS");
        for (Result r : fails) {
            System.err.println(r);
        }
        return false;
    }

    public String toString() {
        return "TestCase numCase:" + this._tests.size();
    }

    protected static void run(String[] args) {
        Args a = new Args(args);
        boolean foundMe = false;
        String theClass = null;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (foundMe) {
                theClass = ste.getClassName();
                break;
            }
            if (!ste.getClassName().equals("com.mongodb.util.TestCase") || !ste.getMethodName().equals("run")) continue;
            foundMe = true;
        }
        if (theClass == null) {
            throw new RuntimeException("something is broken");
        }
        try {
            TestCase tc = (TestCase)Class.forName(theClass).newInstance();
            if (a.getOption("m") != null) {
                tc = new TestCase((Object)tc, a.getOption("m"));
            }
            tc.runConsole();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        String line;
        String dir = "src/test";
        if (args != null && args.length > 0) {
            dir = args[0];
        }
        Process p = Runtime.getRuntime().exec("find " + dir);
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        TestCase theTestCase = new TestCase();
        while ((line = in.readLine()) != null) {
            if (!line.endsWith("Test.java")) continue;
            line = line.substring("src/test/".length());
            line = line.substring(0, line.length() - ".java".length());
            line = line.replaceAll("//+", "/");
            line = line.replace('/', '.');
            try {
                Class<?> c = Class.forName(line);
                Object thing = c.newInstance();
                if (!(thing instanceof TestCase)) continue;
                System.out.println(line);
                TestCase tc = (TestCase)thing;
                theTestCase._tests.addAll(tc._tests);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        theTestCase.runConsole();
    }

    static class Result {
        final Test _test;
        final Throwable _error;

        Result(Test t) {
            this(t, null);
        }

        Result(Test t, Throwable error) {
            this._test = t;
            this._error = error;
        }

        boolean ok() {
            return this._error == null;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this._test);
            for (Throwable error = this._error; error != null; error = error.getCause()) {
                buf.append("\n\t" + error + "\n");
                for (StackTraceElement ste : error.getStackTrace()) {
                    buf.append("\t\t" + ste + "\n");
                }
            }
            return buf.toString();
        }
    }

    static class Test {
        protected String _name = null;
        final Object _o;
        final Method _m;

        Test(Object o, Method m) {
            this._o = o;
            this._m = m;
        }

        Result run() {
            try {
                this._m.invoke(this._o, new Object[0]);
                return new Result(this);
            }
            catch (IllegalAccessException e) {
                return new Result(this, e);
            }
            catch (InvocationTargetException ite) {
                return new Result(this, ite.getTargetException());
            }
        }

        public String toString() {
            String foo = this._o.getClass().getName() + "." + this._m.getName();
            if (this._name == null) {
                return foo;
            }
            return this._name + "(" + foo + ")";
        }
    }
}

