/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ObjectId;
import com.mongodb.util.gridfs.GridFS;
import com.mongodb.util.gridfs.GridFSChunk;
import com.mongodb.util.gridfs.GridFSInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GridFSObject {
    private ObjectId _id;
    private String _filename;
    private String _contentType = "application/octet-stream";
    private long _length = 0L;
    private int _chunkSize = 262144;
    private Date _uploadDate = new Date();
    private List<String> _aliases = new ArrayList<String>();
    private DBObject _metadata;
    private byte[] _myBuffer = new byte[262144];
    private InputStream _inStream;
    private int _nextChunkID = 0;
    private GridFS _gridfs;
    private DBCursor _chunkCursor;

    public GridFSObject(String name, InputStream inStream) {
        this._id = new ObjectId();
        this._filename = name;
        this._inStream = inStream;
    }

    public GridFSObject(GridFS gridfs, DBObject o) {
        this(gridfs, o, (DBObject)o.get("metadata"));
    }

    public GridFSObject(GridFS gridfs, DBObject o, DBObject metadata) {
        this._gridfs = gridfs;
        this._id = (ObjectId)o.get("_id");
        this._filename = (String)o.get("filename");
        this._inStream = null;
        this._contentType = (String)o.get("contentType");
        Object len = o.get("length");
        Double d = ((Number)(len == null ? Integer.valueOf(0) : len)).doubleValue();
        this._length = d == null ? 0L : d.longValue();
        this._chunkSize = o.containsField("chunkSize") ? (Integer)o.get("chunkSize") : 262144;
        this._uploadDate = (Date)o.get("uploadDate");
        this._metadata = metadata;
        this._chunkCursor = gridfs.getChunkCursorForFile(this._id);
    }

    public InputStream getInputStream() {
        return new GridFSInputStream(this);
    }

    protected GridFSChunk getNextChunkFromDB() {
        if (!this._chunkCursor.hasNext()) {
            return null;
        }
        return new GridFSChunk(this._chunkCursor.next());
    }

    protected GridFSChunk getNextChunkFromStream() throws IOException {
        GridFSChunk gridFSChunk;
        int len;
        if (this._inStream == null) {
            if (this._filename == null) {
                throw new RuntimeException("no input stream of filename");
            }
            this._inStream = new FileInputStream(this._filename);
        }
        if ((len = this._inStream.read(this._myBuffer)) <= 0) {
            gridFSChunk = null;
        } else {
            int n = this._nextChunkID++;
            gridFSChunk = new GridFSChunk(this._id, this._myBuffer, len, n);
        }
        return gridFSChunk;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    protected void setLength(long l) {
        this._length = l;
    }

    public ObjectId getID() {
        return this._id;
    }

    public DBObject getMetadata() {
        return this._metadata;
    }

    public DBObject getDBObject() {
        BasicDBObject o = new BasicDBObject();
        o.put("_id", (Object)this._id);
        o.put("filename", (Object)this._filename);
        o.put("contentType", (Object)this._contentType);
        o.put("length", (Object)this._length);
        o.put("chunkSize", (Object)this._chunkSize);
        o.put("uploadDate", (Object)this._uploadDate);
        o.put("aliases", (Object)this._aliases);
        o.put("metadata", (Object)this._metadata);
        return o;
    }
}

