/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.DBObject;
import com.mongodb.DBRefBase;
import com.mongodb.ObjectId;
import com.mongodb.util.JSONParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;

public class JSON {
    public static String serialize(Object o) {
        StringBuilder buf = new StringBuilder();
        JSON.serialize(o, buf);
        return buf.toString();
    }

    static void string(StringBuilder a, String s) {
        a.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ') continue;
            if (c == '\\') {
                a.append("\\\\");
                continue;
            }
            if (c == '\"') {
                a.append("\\\"");
                continue;
            }
            if (c == '\n') {
                a.append("\\n");
                continue;
            }
            if (c == '\r') {
                a.append("\\r");
                continue;
            }
            if (c == '\t') {
                a.append("\\t");
                continue;
            }
            a.append(c);
        }
        a.append("\"");
    }

    public static void serialize(Object o, StringBuilder buf) {
        if (o == null) {
            buf.append(" null ");
            return;
        }
        if (o instanceof Number) {
            buf.append(o);
            return;
        }
        if (o instanceof String) {
            JSON.string(buf, o.toString());
            return;
        }
        if (o instanceof List) {
            boolean first = true;
            buf.append("[ ");
            for (Object n : (List)o) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.serialize(n, buf);
            }
            buf.append("]");
            return;
        }
        if (o instanceof ObjectId) {
            JSON.string(buf, o.toString());
            return;
        }
        if (o instanceof DBObject) {
            boolean first = true;
            buf.append("{ ");
            DBObject dbo = (DBObject)o;
            for (String name : dbo.keySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" , ");
                }
                JSON.string(buf, name);
                buf.append(" : ");
                JSON.serialize(dbo.get(name), buf);
            }
            buf.append("}");
            return;
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            buf.append('\"').append(format.format(d)).append('\"');
            return;
        }
        if (o instanceof Boolean || o instanceof DBRefBase) {
            buf.append(o);
            return;
        }
        if (o instanceof byte[]) {
            buf.append("<Binary Data>");
            return;
        }
        throw new RuntimeException("can't serialize type : " + o.getClass());
    }

    public static DBObject parse(String s) {
        if (s == null || (s = s.trim()).equals("")) {
            return null;
        }
        JSONParser p = new JSONParser(s);
        return p.parseObject();
    }
}

